#include <SDL.h>

#define LARGEUR_ECRAN 640
#define HAUTEUR_ECRAN 480

void projeter(float, float, float, int*, int*);
void afficherPixel(SDL_Surface*, int, int, Uint32);

int main(int argc, char *argv[])
{
	SDL_Surface *screen;
	SDL_Event event;
	float x3, y3, z3;
	int x2, y2;
	Uint8 *keys;
	char done = 0;

	SDL_Init(SDL_INIT_VIDEO);
	screen = SDL_SetVideoMode(LARGEUR_ECRAN, HAUTEUR_ECRAN, 32, SDL_HWSURFACE);

	x3 = 10;
	y3 = 30;
	z3 = 70;

	while(!done)
	{
		SDL_PollEvent(&event);
		keys = SDL_GetKeyState(NULL);
		done = keys[SDLK_ESCAPE];

		// C'est ici que les choses qui nous intressent se passent
		projeter(x3, y3, z3, &x2, &y2);
		afficherPixel(screen, x2 + LARGEUR_ECRAN / 2, HAUTEUR_ECRAN / 2 + y2, 0xffffff);

		if(keys[SDLK_UP])
			z3 = z3 + 1;
		else if(keys[SDLK_DOWN])
			z3 = z3 - 1;

		if(keys[SDLK_LEFT])
			x3 = x3 - 1;
		else if(keys[SDLK_RIGHT])
			x3 = x3 + 1;

		SDL_Flip(screen);
		SDL_FillRect(screen, NULL, 0);
	}

	SDL_Quit();
	return 0;
}

void projeter(float a, float b, float c, int *x, int *y)
{
	*x = (int)(a * 64 / (c + 150));
	*y = (int)(b * 64 / (c + 150));
}

void afficherPixel(SDL_Surface *screen, int x, int y, Uint32 couleur)
{
	Uint8 *p;
	if(x >= 0 && x < LARGEUR_ECRAN && y >= 0 && y < HAUTEUR_ECRAN)
	{
		SDL_LockSurface(screen);
		p = (Uint8*)screen->pixels + y * screen->pitch + x * screen->format->BytesPerPixel;
		*(Uint32 *)p = couleur;
		SDL_UnlockSurface(screen);
	}
}
