
#ifndef __GAME_H__
#define __GAME_H__

/* Defines */
#define FBW 320
#define FBH 200

/* Enums */
typedef enum
{
  ENone = 0,  
  EExplode = 1,
  ECam = 2,  
  EMine = 3,
  ETorpedo = 4,
  EDrone = 5,
  ETransport = 6,
  EBadTorpedo = 7
} EObjType;

typedef enum
{
  EIdle = 0,
  EAttack = 1,
  EAvoid = 2
} EDroneState;

/* Structs */
typedef struct
{
  int nbtri;
  int maxY;
  int minY;
  int sqrad;
} TBinObj;

typedef struct
{
  int x;
  int y;
  int z;
  int angley;
  int explode;
  int maxY;
  int minY;
  int sqrad;
  int objtype;
  int sonX;
  int sonZ;
  TBinObj* objdata;
  int step;
  int dammage;
  int shield;
  int dx;
  int dz;
  int state;  
} TObjTrans;

typedef struct
{
  int Xw;
  int Yw;
  int Zw;
  int Xt;
  int Yt;
  int Zt;
  int Xproj;
  int Yproj;
  int index;  
} TVertex;

typedef struct
{
  TVertex v[3];
  int color;
  int z;
  int nx;
  int ny;
  int nz;
  int nxt;
  int nyt;
  int nzt;
} TTriangle;

typedef struct
{
  int sonarenabled;
  int sonarstep;
  int sonarbeep;
  int toodeep;
  int speed;
  int compass;
} TShip;

typedef struct
{
  int nbmines;
  int nbtransports;
  int nbdrones;
  int minesObjective;
  int transportsObjective;
  int dronesObjective;
  char* message;
  TBinObj* showObj;
} TLevel;

typedef struct
{
  TBinObj* obj;
  TObjTrans* trans;
} TDisplayElement;

/* External functions */
extern void TransformListDSP(void* vidmem, TObjTrans* cam, TTriangle* triclipped[]);
extern void Raster(void* vidmem, TTriangle* triclipped[], int nTriClipped);
extern void CollisionDSP(TObjTrans* tester, TObjTrans* tested, int nobj, int exception);
extern void SortTriDSP(TTriangle* triclipped[], int ntri);
extern void DrawSonar(void* vidmem, TObjTrans* cam, TObjTrans* objects, int n, int step);

extern void SetModeClock(int);

extern void SetVoice(int n, char* ptloop, char* ptstart, char* ptend);
extern void SetVoiceVol(int n, int left, int right);
extern void SetVoiceStep(int n, int step);
extern void WaitFrame(int n);

/* External data */
extern unsigned char vidmem;
extern short sintab;
extern short asintab;
extern unsigned char font8x8_8;
extern unsigned char font8x8_8f;
extern unsigned short palette;
extern unsigned char title;

extern TBinObj PlanctonObj;
extern TBinObj MineObj;
extern TBinObj TorpedoObj;
extern TBinObj TransportObj;
extern TBinObj ShipObj;
extern TBinObj DroneObj;
extern TBinObj RedTorpedoObj;
extern TBinObj PlayerShipObj;

extern TDisplayElement displayList;
extern int nDisplay;
extern int nTriAdd;
extern int* ptTriAdd;
extern int trisAdd;
extern int trisAdd2;

extern char sonar2sound;
extern char sonar2soundend;
extern char crunchsound;
extern char crunchsoundend;
extern char explodesound;
extern char explodesoundend;
extern char metalsound;
extern char metalsoundend;
extern char torpedosound;
extern char torpedosoundend;
extern char AStrangerDeathsound;
extern char AStrangerDeathsoundend;

extern int timer8KHz;


/* Functions */
int MainLoop();
int MenuLoop();
int GameLoop(TLevel*);




#endif /* __GAME_H__ */