    .include "jaguar.inc"
    .include "graphics.inc"
    .include "game68k.inc"

; -------------------------------------------------------
; Globals
; -------------------------------------------------------    
   

; -------------------------------------------------------
; Constants
; -------------------------------------------------------    
CLIP_DIST equ 1024
    
; -------------------------------------------------------
; Externals
; -------------------------------------------------------
    .extern _systemtype
  ;  .extern Ytab
    .extern gpuparam1
    .extern gpuparam2
    .extern gpuparam3
    .extern gpuparam4
    .extern gpuparam5
    .extern gpuparam6
    .extern _sintab      
    .extern _nTriAdd
    .extern _ptTriAdd

		.gpu
_gpucode3d::
		.org G_RAM	
_startgpucode3d::
    
; -------------------------------
; Dispatch requests from host cpu
gpusemcheck:     
    movei #GPUSEM,r20
    movei #DrawSonar,r21
    movei #Raster,r22
    movei #StopGPU,r23
    
testgpusem:
    load  (r20),r0
    
    cmpq  #1,r0       ; DrawSonar
    jump  eq,(r21)
    nop
   
    cmpq  #2,r0       ; Raster
    jump  eq,(r22)
    nop
         
    cmpq  #3,r0       ; Stop GPU
    jump  eq,(r23)
    nop
    
    jr    testgpusem
    nop


; ----------------------------------------
; Raster
rX  .equr r8
rY  .equr r9
rZ  .equr r10
rPtDst  .equr r11
rPtGeom .equr r12
rBCMD   .equr r13
rBLIT   .equr r14

rOne16  .equr r16
rSize   .equr r17
rX2 .equr r18
rY2 .equr r19
rYmin .equr r20
rYmax .equr r21
rDX   .equr r22
rPtr  .equr r23
rZ2 .equr r24
rNclipped .equr r25
rGap  .equr r26
rSorted .equr r27
rHIDATA  .equr r28

oA1BASE   .equ  $0
oA1FLAGS  .equ  ($04>>2)
oA1CLIP   .equ  ($08>>2)
oA1PIXEL  .equ  ($0C>>2)
oA1STEP .equ  ($10>>2)
oA1FSTEP  .equ  ($14>>2)
oA1FPIXEL .equ  ($18>>2)
oA1INC  .equ  ($1C>>2)
oA1FINC .equ  ($20>>2)
oA2BASE .equ  ($24>>2)
oA2FLAGS  .equ  ($28>>2)
oA2PIXEL  .equ  ($30>>2)
oA2STEP   .equ  ($34>>2)
oBCMD   .equ  ($38>>2)
oBCOUNT .equ  ($3C>>2)
oBSRCD  .equ  ($40>>2)
oBDSTD  .equ  ($48>>2)
oBPATD  .equ  ($68>>2)
oBPATD2 .equ  ($6C>>2)
oBIINC  .equ  ($70>>2)

cXcam   .equr r0
cYcam   .equr r1
cZcam   .equr r2
cType   .equr r3
cYtab   .equr r4
cPtr    .equr r5
cNbTri  .equr r6
cScrW   .equr r7
cScrH   .equr r8
cBlitCmd  .equr r9
cHalfW  .equr r10
cHalfH  .equr r11

   
Raster:
  movei #BMP_WIDTH,r0
  moveta  r0,cScrW
  shrq  #1,r0
  moveta  r0,cHalfW
  movei #BMP_HEIGHT,r0
  moveta  r0,cScrH
  shrq  #1,r0
  moveta  r0,cHalfH
  movei #G_HIDATA,rHIDATA
  
  movei #gpuparam1,r0
  load  (r0),rPtDst
    
  movei #gpuparam2,r0
  load  (r0),rPtr
    
  movei #gpuparam3,r0
  load  (r0),rNclipped
  
  movei #endRaster,r0
  move  rNclipped,r7
  cmpq  #0,r7
  jump  eq,(r0)
  nop

  movei #BMP_HEIGHT-1,r6
  moveq #0,r0
  movei #Ytab,r1
.clearYtab:
    store r0,(r1)
    addqt #4,r1
    store r0,(r1)
    addqt #4,r1
    subq  #1,r6
    jr  pl,.clearYtab
    nop
    
  movei #(1<<16),rOne16
  
  movei #.initLoopTriRaster,r31
  movei #shellSort,r0
  jump  (r0)
  nop
  
.initLoopTriRaster:
  move  rNclipped,r7
  subq  #1,r7
      
loopTriRaster:
    movei #CVertexSz,rSize
    load  (rPtr),rPtGeom
    move  rPtGeom,r14   
    movei #QX0,r15
    
    moveq #2,r6
.loopCopyVertices:
      load  (r14+CVertexXproji),rX
      load  (r14+CVertexYproji),rY
      store rX,(r15)
      store rY,(r15+1)
      add rSize,r14
      addqt #12,r15
      subq  #1,r6
      jr  pl,.loopCopyVertices
      nop
   
    movefa  cScrH,r0
    subq  #1,r0
    move  r0,rYmin
    moveq  #0,rYmax   

; Test poly inside screen (noclip)
    movefa  cScrW,r1
    subq  #1,r1      
    moveq #2,r6
    movei #QX0,r14
    movei #.testPolyInside,r30
    movei #.line01,r29
.testPolyInside:
      load  (r14),rX
      load  (r14+1),rY
      addqt #12,r14
      
      cmpq  #0,rX
      jr  pl,.XleftOK
      nop        
      jump  (r29)
      nop
.XleftOK:
      cmp  r1,rX
      jr  mi,.XrightOK
      nop
      jump  (r29)
      nop
.XrightOK:
      cmpq  #0,rY
      jr  pl,.YtopOK
      nop
      jump  (r29)
      nop
.YtopOK:
      cmp   r0,rY
      jr  mi,.YbottomOK
      nop
      jump  (r29)
      nop
.YbottomOK:                  
      subq  #1,r6
      jump  pl,(r30)
      nop

    movei #line01noClip,r0
    jump  (r0)
    nop
          
.line01:
    movei #QX0,r14
    load  (r14),rX
    load  (r14+1),rY
    addqt #12,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.line12,r31
    movei #interpoleLine,r0
    jump  (r0)
    nop
    
.line12:
    movei #QX1,r14
    load  (r14),rX
    load  (r14+1),rY
    addqt #12,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.line20,r31
    movei #interpoleLine,r0
    jump  (r0)
    nop
    
.line20:
    movei #QX2,r14
    load  (r14),rX
    load  (r14+1),rY
    movei #QX0,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.drawRaster,r31
    movei #interpoleLine,r0
    jump  (r0)
    nop

.drawRaster:
    movei #A1_BASE,rBLIT
    movei #B_CMD,rBCMD
    
    movei #CTriangleCol,r0
    add rPtGeom,r0
    load  (r0),r3
    move  r3,r4
    shlq  #8,r4
    or  r4,r3
    shlq  #8,r4
    or  r4,r3
    shlq  #8,r4
    or  r4,r3

.waitBLIT1:
      load  (rBCMD),r0
      btst  #0,r0
      jr  eq,.waitBLIT1
      nop
      
    store rPtDst,(rBLIT+oA1BASE)
    movei #PITCH1|PIXEL8|XADDPHR|WID320,r0
    store r0,(rBLIT+oA1FLAGS)
    store r3,(rBLIT+oBPATD)
    store r3,(rBLIT+oBPATD2)
    movei #PATDSEL|LFU_REPLACE,r0
    moveta  r0,cBlitCmd
    
    movei #Ytab,rZ
    movei #.nextTriRaster,r0
    sub rYmin,rYmax
    jump  mi,(r0)
    nop
    jump  eq,(r0)
    nop
    moveta  rYmin,cPtr
    
    move  rYmin,r2
    movefa  cScrW,rSize
    movefa  cScrW,r5
    subq  #1,r5     ; for clipping
  
    shlq  #3,rYmin
    shlq  #16,r2
    add rYmin,rZ
    movei #.loopRasterRows,r30
    movei #.nextRasterRow,r29
.loopRasterRows:    
      ;loadp (rZ),r1
      ;or  r1,r1        
      ;load  (rHIDATA),r0  
      ;addqt #8,rZ
      
      load (rZ),r0
      addq #4,rZ
      load (rZ),r1
      addq #4,rZ     
   
      sat16 r0
      cmp  r5,r0
      jump  pl,(r29)  ; x start outside of screen
      nop
      
      cmpq  #0,r1
      jump  mi,(r29)  ; x end outside of screen
      nop
      cmp  r5,r1
      jr  mi,.rasterRowX1noclip
      nop
      move  r5,r1
.rasterRowX1noclip:       
      sub r0,r1   ; length
      sat16 r1
      jump  eq,(r29)
      nop

      or  r2,r0   ; Y|X
.waitBLIT2:
        load  (rBCMD),r3
        btst  #0,r3
        jr  eq,.waitBLIT2
        nop        
        
      store r0,(rBLIT+oA1PIXEL)        
      or  rOne16,r1
      movefa cBlitCmd,r0
      store r1,(rBLIT+oBCOUNT)        
      store r0,(rBCMD)
    
.nextRasterRow:        
      subq  #1,rYmax
      jump  pl,(r30)
      add rOne16,r2
        
      
.nextTriRaster:
    movei #loopTriRaster,r0
    addqt #4,rPtr
    subq  #1,r7
    jump  pl,(r0)
    nop
      
endRaster:       
  movei #GPURES,r20
  move  rNclipped,r0
  store r0,(r20)

  movei #GPUSEM,r20
  moveq #31,r0
  store r0,(r20)  
  movei #gpusemcheck,r20
  jump  (r20)
  nop

; -------------------------------------------
; nolcip routine
line01noClip:
    movei #QX0,r14
    load  (r14),rX
    load  (r14+1),rY
    addqt #12,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.line12noClip,r31
    movei #interpoleLineNoClip,r0
    jump  (r0)
    nop
    
.line12noClip:
    movei #QX1,r14
    load  (r14),rX
    load  (r14+1),rY
    addqt #12,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.line20noClip,r31
    movei #interpoleLineNoClip,r0
    jump  (r0)
    nop
    
.line20noClip:
    movei #QX2,r14
    load  (r14),rX
    load  (r14+1),rY
    movei #QX0,r14
    load  (r14),rX2
    load  (r14+1),rY2
    movei #.drawRasterNoClip,r31
    movei #interpoleLineNoClip,r0
    jump  (r0)
    nop

.drawRasterNoClip:
    movei #A1_BASE,rBLIT
    movei #B_CMD,rBCMD
    
    movei #CTriangleCol,r0
    add rPtGeom,r0
    load  (r0),r3
    move  r3,r4
    shlq  #8,r4
    or  r4,r3
    shlq  #8,r4
    or  r4,r3
    shlq  #8,r4
    or  r4,r3

.waitBLIT1noclip:
      load  (rBCMD),r0
      btst  #0,r0
      jr  eq,.waitBLIT1noclip
      nop
            
    store rPtDst,(rBLIT+oA1BASE)
    movei #PITCH1|PIXEL8|XADDPHR|WID320,r0
    store r0,(rBLIT+oA1FLAGS)
    store r3,(rBLIT+oBPATD)
    store r3,(rBLIT+oBPATD2)
    movei #PATDSEL|LFU_REPLACE,r0
    moveta  r0,cBlitCmd
          
    movei #Ytab,rZ
    movei #.nextTriRasterNoClip,r0
    
    sub rYmin,rYmax
    jump  mi,(r0)
    nop
    jump  eq,(r0)
    nop
    moveta  rYmin,cPtr
    
    move  rYmin,r2
    movefa  cScrW,rSize
  
    shlq  #3,rYmin
    shlq  #16,r2
    add rYmin,rZ
    movei #.loopRasterRowsNoClip,r30
    movei #.nextRasterRowNoClip,r29
.loopRasterRowsNoClip:
      ;loadp (rZ),r1
      ;or  r1,r1        
      ;load  (rHIDATA),r0  
      ;addqt #8,rZ
      load (rZ),r0
      addq #4,rZ
      load (rZ),r1
      addq #4,rZ     
            
      sub r0,r1   ; length
      sat16 r1
      jump  eq,(r29)
      nop

      or  r2,r0   ; Y|X
.waitBLIT2noClip:
        load  (rBCMD),r3
        btst  #0,r3
        jr  eq,.waitBLIT2noClip
        nop        
      store r0,(rBLIT+oA1PIXEL)        
      or  rOne16,r1
      movefa cBlitCmd,r0
      store r1,(rBLIT+oBCOUNT)        
      store r0,(rBCMD)      

.nextRasterRowNoClip:        
      subq  #1,rYmax
      jump  pl,(r30)
      add rOne16,r2
      
.nextTriRasterNoClip:
    movei #loopTriRaster,r0
    addqt #4,rPtr
    subq  #1,r7
    jump  pl,(r0)
    nop
  
  movei #endRaster,r0
  jump (r0)
  nop

  
; -------------------------------------------  
; StartPoint: rX,rY
; EndPoint: rX2,rY2
interpoleLine:
  movei #Ytab,r0
  moveta  r0,cYtab
  movei #.Ydiff,r30
  cmp rY,rY2
  jump  ne,(r30)
  nop
  
  ; Test line outside of screen vertically
  movefa  cScrH,r0
  subq  #1,r0
  cmp r0,rY
  jump  pl,(r31)
  nop
  cmpq  #0,rY
  jump  mi,(r31)
  nop
  
  ; X: start, X2: end
  cmp rX,rX2
  jump  mi,(r31)
  nop

  ; Test line outside of screen horizontally
  movefa  cScrW,r0
  subq  #1,r0
  cmp r0,rX
  jump  pl,(r31)
  nop
  cmpq  #0,rX2
  jump  mi,(r31)
  nop
  
  cmp rYmin,rY
  jr  pl,.testYmax
  nop
  move  rY,rYmin
.testYmax:
  cmp rYmax,rY
  jr  mi,.writeHorLine
  nop
  move  rY,rYmax
        
.writeHorLine:
  movefa cYtab,rZ
  shlq  #3,rY
  add   rY,rZ
  store  rX,(rZ)
  addqt #4,rZ
  store  rX2,(rZ)
  jump  (r31)
  nop  
  
.Ydiff:
  cmp rY,rY2
  jr  pl,.lineLeft
  nop
  move  rY,r0
  move  rY2,rY
  move  r0,rY2
  move  rX,r0
  move  rX2,rX
  move  r0,rX2
  movefa  cYtab,rZ
  addq  #4,rZ
  jr  .testLineInScreen
  nop
.lineLeft:
  movefa  cYtab,rZ
  
.testLineInScreen:
  movefa  cScrH,r0
  subq  #1,r0
  cmp r0,rY         ; bottom
  jump  pl,(r31)
  nop
  cmpq  #0,rY2      ; top
  jump  mi,(r31)
  nop
  
  move  rX2,rDX
  move  rY2,r5
  sub rX,rDX
  sub rY,r5
  shlq  #10,rDX
  move  rDX,r4
  abs rDX
  div r5,rDX
  cmpq  #0,r4
  jr  pl,.DXpos
  nop
  neg rDX
.DXpos:
    
  cmp r0,rY2    ; clip bottom
  jr  mi,.noClipBottom
  nop
  move  r0,rY2
  move  r0,r5
  sub   rY,r5  
.noClipBottom:
  
  cmpq  #0,rY   ; clip top
  jr  pl,.noClipTop
  nop
  move  rY,r4
  abs r4
  imult rDX,r4
  sharq #10,r4
  add r4,rX
  moveq #0,rY
  move  rY2,r5  
.noClipTop:

  cmp rYmin,rY
  jr  pl,.testYmax2
  nop
  move  rY,rYmin
.testYmax2:
  cmp rYmax,rY2
  jr  mi,.prepInterpole
  nop
  move  rY2,rYmax
 
.prepInterpole:
  shlq  #3,rY
  shlq  #10,rX
  add rY,rZ
  movei #.loopInterpole,r30
.loopInterpole:
    move  rX,r0
    sharq #10,r0
    store  r0,(rZ)
    add rDX,rX
    subq  #1,r5
    jump  pl,(r30)
    addqt #8,rZ
   
  jump  (r31)
  nop
  
; -------------------------------------------
; StartPoint: rX,rY
; EndPoint: rX2,rY2
interpoleLineNoClip:
  movei #Ytab,r0
  moveta  r0,cYtab
  movei #.Ydiff,r30
  cmp rY,rY2
  jump  ne,(r30)
  nop
  
  ; X: start, X2: end
  cmp rX,rX2
  jump  mi,(r31)
  nop

  cmp rYmin,rY
  jr  pl,.testYmax
  nop
  move  rY,rYmin
.testYmax:
  cmp rYmax,rY
  jr  mi,.writeHorLine
  nop
  move  rY,rYmax
        
.writeHorLine:
  movefa cYtab,rZ
  shlq  #3,rY
  add   rY,rZ
  store  rX,(rZ)
  addqt #4,rZ
  store  rX2,(rZ)
  jump  (r31)
  nop
  
  
.Ydiff:
  cmp rY,rY2
  jr  pl,.lineLeft
  nop
  move  rY,r0
  move  rY2,rY
  move  r0,rY2
  move  rX,r0
  move  rX2,rX
  move  r0,rX2
  movefa  cYtab,rZ
  addq  #4,rZ
  jr  .computeDX
  nop
.lineLeft:
  movefa  cYtab,rZ
  
.computeDX: 
  move  rX2,rDX
  move  rY2,r5
  sub rX,rDX
  sub rY,r5
  shlq  #10,rDX
  move  rDX,r4
  abs rDX
  div r5,rDX
  cmpq  #0,r4
  jr  pl,.DXpos
  nop
  neg rDX
.DXpos:
 
  cmp rYmin,rY
  jr  pl,.testYmax2
  nop
  move  rY,rYmin
.testYmax2:
  cmp rYmax,rY2
  jr  mi,.prepInterpole
  nop
  move  rY2,rYmax
 
.prepInterpole:
  shlq  #3,rY
  shlq  #10,rX
  add rY,rZ
  movei #.loopInterpole,r30
.loopInterpole:
    move  rX,r0
    sharq #10,r0
    store  r0,(rZ)
    add rDX,rX
    subq  #1,r5
    jump  pl,(r30)
    addqt #8,rZ
   
  jump  (r31)
  nop

; -------------------------------------------
; Shell sort
; rPtr: array
; rNclipped: input size

shellSort:  
  cmpq  #2,rNclipped
  jump  mi,(r31)
  nop
  
  move  rNclipped,rGap
  sharq #1,rGap         ; gap = n/2
.loopForGap:
    cmpq  #0,rGap       ; gap==0, return
    jump eq,(r31)       
    nop
    
    move  rGap,r6       ; i = gap
.loopForI:
      movei #.breakForI,r0
      cmp r6,rNclipped
      jump eq,(r0)
      nop
      
      move  r6,r0
      shlq  #2,r0
      add rPtr,r0
      load  (r0),r15   ; temp = arr[i]
      
      move  r6,r7   ; j =i
.loopForJ:
        movei #.breakForJ,r0
        cmp rGap,r7 ; j>=gap continue => j<gap break        
        jump  mi,(r0)
        nop
        
        move  r7,r5
        sub   rGap,r5
        shlq  #2,r5
        add rPtr,r5
        load  (r5),r14  ; arr[j-gap]
        
        movei #CTriangleZ,r1
        load  (r14+r1),rZ ; arr[j-gap].z
        load  (r15+r1),rZ2  ; temp.z
        cmp rZ2,rZ
        jump  pl,(r0)
        nop
        
        move  r7,r4
        shlq  #2,r4
        add rPtr,r4 
        store r14,(r4)  ; arr[j] = arr[j - gap];
        
        movei #.loopForJ,r0
        sub rGap,r7
        jump  (r0)
        nop
              
.breakForJ:
      ; arr[j] = temp
      move  r7,r4
      shlq  #2,r4
      add rPtr,r4 
      store r15,(r4)
        
      movei #.loopForI,r0
      addq  #1,r6
      jump  (r0)
      nop
      
.breakForI:
    movei #.loopForGap,r0
    sharq #1,rGap       ; gap /=2
    jump  (r0)
    nop
  

  .equrundef rX
  .equrundef rY 
  .equrundef rZ  
  .equrundef rPtDst
  .equrundef rPtGeom
  .equrundef rBCMD
  .equrundef rBLIT

  .equrundef rOne16
  .equrundef rSize
  .equrundef rX2
  .equrundef rY2
  .equrundef rYmin
  .equrundef rYmax
  .equrundef rDX
  .equrundef rPtr
  .equrundef rZ2
  .equrundef rNclipped
  .equrundef rGap
  .equrundef rSorted  
  
  .equrundef cYcam
  .equrundef cXcam
  .equrundef cZcam
  .equrundef cType
  .equrundef cYtab
  .equrundef cPtr
  .equrundef cNbTri
  .equrundef cScrW
  .equrundef cScrH
  .equrundef cBlitCmd
  .equrundef cHalfW
  .equrundef cHalfH
  
 
  
; ------------------------------------------------
;  StopGPU
; No parameters        
StopGPU:	
	movei  #0,r0		; Stop GPU
	movei  #G_CTRL,r1
	store   r0,(r1)	 
		nop             		; Two "feet" on the brake pedal
		nop


; ----------------------------------------
; DrawSonar
rX  .equr r8
rY  .equr r9
rZ  .equr r10
rX2  .equr r11
rY2  .equr r12
rZ2  .equr r13
rPtDst  .equr r16
rCol    .equr r17
rPtr    .equr r18
rStep   .equr r19

cScrW   .equr r0
cHalfW  .equr r1
cScrH   .equr r2
cHalfH  .equr r3
cXcam   .equr r4
cYcam   .equr r5
cZcam   .equr r6
cVidMem .equr r7
cSinAcam  .equr r8
cCosAcam  .equr r9

DrawSonar:
  movei #BMP_WIDTH,r0
  moveta  r0,cScrW
  shrq  #1,r0
  moveta  r0,cHalfW
  movei #BMP_HEIGHT,r0
  moveta  r0,cScrH
  shrq  #1,r0
  moveta  r0,cHalfH
  
  ; pt vid mem
  movei #gpuparam1,r0
  load (r0),r0
  moveta  r0,cVidMem
  move  r0,rPtDst
  
  ; pt cam
  movei #gpuparam2,r0
  load  (r0),r14
  load  (r14+CObjTransXi),r0
  moveta  r0,cXcam
  load  (r14+CObjTransYi),r0
  moveta  r0,cYcam
  load  (r14+CObjTransZi),r0
  moveta  r0,cZcam
  load  (r14+CObjTransAngleYi),r3
  
  movei #_sintab,rPtr
  movei #2047,r2
  move  r3,r0
  and   r2,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  moveta  r1,cSinAcam
  
  move  r3,r0
  movei #512,r1  
  add r1,r0
  and r2,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  moveta  r1,cCosAcam  

  ; pt objects
  movei #gpuparam3,r0
  load  (r0),r14
  
  ; n objets
  movei #gpuparam4,r0
  load  (r0),r7
  
  ; sonar step
  movei #gpuparam5,r0
  load  (r0),rStep
  
  movei #16,rCol
  movefa  cHalfW,r0
  movefa  cHalfH,r1
  movefa  cScrW,r2
  imult   r2,r1
  add r0,r1
  add rPtDst,r1
  storeb  rCol,(r1)
  
  movei #48,r0
  movei #32,rCol
  add rStep,rCol
  cmp r0,rCol
  jr  mi,.testStep
  nop
  move  r0,rCol
  subq  #1,rCol

.testStep:
  movei #.loopPersistence,r0
  cmpq  #0,rStep
  jump  ne,(r0)
  nop
  
.loopRefreshObj:
  movei #.nextLoop,r0
  load (r14+CObjTransObjtypei),r1
  cmpq  #3,r1   ; objects type 0  2: ne pas afficher
  jump  mi,(r0)
  nop
  
  load (r14+CObjTransXi),rX
  load (r14+CObjTransZi),rZ
  movefa cXcam,r0
  movefa cZcam,r1
  sub r0,rX
  sub r1,rZ
  
  ; cam rotY
  move  rX,rX2  
  move  rZ,rZ2

  movefa  cCosAcam,r0
  movefa  cSinAcam,r1
  sharq #5,rX   ; reduce precision to improve range
  sharq #5,rZ
  imult r0,rX
  imult r1,rZ
  sharq #5,rX
  sharq #5,rZ
  sub rZ,rX
  
  sharq #5,rX2   ; reduce precision to improve range
  sharq #5,rZ2
  imult r1,rX2
  imult r0,rZ2
  sharq #5,rX2
  sharq #5,rZ2
  add rX2,rZ2
  move  rZ2,rZ   
  
  neg rZ
  
  sharq #13,rX
  sharq #13,rZ
  
  store rX,(r14+CObjTransSonXi)
  store rZ,(r14+CObjTransSonZi)
    
  movefa  cHalfW,r0
  movefa  cHalfH,r1
  add r0,rX
  add r1,rZ
  movefa  cScrW,r0
  imult r0,rZ
  add rX,rZ
  add rPtDst,rZ  
  storeb rCol,(rZ)

.nextLoop:  
  movei #CObjTransSz,r0
  add r0,r14
  movei #.loopRefreshObj,r0
  subq  #1,r7
  jump  ne,(r0)
  nop
  
  movei #.endSonar,r0
  jump  (r0)
  nop
  

.loopPersistence:
  movei #.nextPeristenceLoop,r0
  load (r14+CObjTransObjtypei),r1
  cmpq  #3,r1   ; objects type 0  2: ne pas afficher
  jump  mi,(r0)
  nop
  
  load (r14+CObjTransSonXi),rX
  load (r14+CObjTransSonZi),rZ
  movefa  cHalfW,r0
  movefa  cHalfH,r1
  add r0,rX
  add r1,rZ
  movefa  cScrW,r0
  imult r0,rZ
  add rX,rZ
  add rPtDst,rZ  
  storeb rCol,(rZ)
  
.nextPeristenceLoop:  
  movei #CObjTransSz,r0
  add r0,r14
  movei #.loopPersistence,r0
  subq  #1,r7
  jump  ne,(r0)
  nop

.endSonar:
  movei #GPURES,r20
  moveq #0,r0
  store r0,(r20)

  movei #GPUSEM,r20
  moveq #31,r0
  store r0,(r20)  
  movei #gpusemcheck,r20
  jump  (r20)
  nop

  .equrundef rX
  .equrundef rY
  .equrundef rZ
  .equrundef rX2
  .equrundef rY2
  .equrundef rZ2
  .equrundef rPtDst
  .equrundef rCol
  .equrundef rPtr

  .equrundef cScrW
  .equrundef cHalfW
  .equrundef cScrH  
  .equrundef cHalfH
  .equrundef cXcam
  .equrundef cYcam
  .equrundef cZcam
  .equrundef cVidMem
  .equrundef cSinAcam
  .equrundef cCosAcam
  
    .long

QCol: dc.l  0
QX0:  dc.l  0
QY0:  dc.l  0
QZ0:  dc.l  0
QX1:  dc.l  0
QY1:  dc.l  0
QZ1:  dc.l  0
QX2:  dc.l  0
QY2:  dc.l  0
QZ2:  dc.l  0

pi: dc.l  0
    dc.l  0
    dc.l  0
po: dc.l  0
    dc.l  0
    dc.l  0
    
_endgpucode3d::
	  nop
		nop

Ytab: dc.l  0

