    .include "jaguar.inc"
    .include "graphics.inc"
    .include "game68k.inc"

; -------------------------------------------------------
; Globals
; -------------------------------------------------------    
    .globl  Voice0
    .globl  Voice1
    .globl  Voice2
    .globl  _timer8KHz
    
; -------------------------------------------------------
; Constants
; -------------------------------------------------------    
CLIP_DIST equ 1024
    
; -------------------------------------------------------
; Externals
; -------------------------------------------------------
    .extern _systemtype
    .extern Ytab
    .extern dspparam1
    .extern dspparam2
    .extern dspparam3
    .extern dspparam4
    .extern dspparam5
    .extern dspparam6
    .extern _sintab      
    .extern _nTriAdd
    .extern _ptTriAdd
    .extern _displayList
    .extern _nDisplay
    
		.dsp
_dspcode3d::
		.org D_RAM	
_startdspcode3d::
  movei #initdsp,r0
  jump  (r0)
  nop  
  nop
  nop
  nop
  
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  
timerint:
  movei #D_FLAGS,r30
  load  (r30),r29
  
  store r24,(r15)
  or  r25,r20 ; scoreboard bug
  store r25,(r15+1)
  
  moveq #0,r24
  move  r24,r25
  move  r24,r26
  move  r25,r27
   
  movei #_timer8KHz,r21
  or  r21,r21
  load  (r21),r22  
  or  r22,r22
  addq  #1,r22
  store r22,(r21)

; Process voice 0       
  movei #Voice0,r14
  or  r14,r14
  load  (r14+CVoiceSplEndi),r21
  load  (r14+CVoiceSplCpti),r23
  
  cmp r21,r23
  jr  mi,.readsample0
  nop
  movei #.readvoice1,r20
  load  (r14+CVoiceSplLoopi),r23
  cmpq  #0,r23
  jump  eq,(r20)
  nop  
.readsample0:
  move  r23,r21
  shrq  #8,r21  
  loadb (r21),r24      
  or  r24,r24  
  move  r24,r25
  load  (r14+CVoiceVolLefti),r28  
  mult r28,r24  ; vol left
  load  (r14+CVoiceVolRighti),r28
  mult r28,r25  ; vol right
  load  (r14+CVoiceStepi),r22
  add   r22,r23 ; step
  or  r23,r20 ; scoreboard bug
  store r23,(r14+CVoiceSplCpti)
 
; Process voice 1
.readvoice1:
  movei #Voice1,r14
  or  r14,r14
  load  (r14+CVoiceSplEndi),r21    
  load  (r14+CVoiceSplCpti),r23
  
  cmp r21,r23
  jr  mi,.readsample1
  nop
  movei #.readvoice2,r20
  load  (r14+CVoiceSplLoopi),r23
  cmpq  #0,r23
  jump  eq,(r20)
  nop  
.readsample1:
  move  r23,r21
  shrq  #8,r21
  loadb (r21),r26  
  or  r26,r26
  move  r26,r27  
  load  (r14+CVoiceVolLefti),r28  
  mult r28,r26  ; vol left
  load  (r14+CVoiceVolRighti),r28
  mult r28,r27  ; vol right
  load  (r14+CVoiceStepi),r22
  add r22,r23 ; step
  add r26,r24 ; mix left
  add r27,r25 ; mix right
  or  r23,r20 ; scoreboard bug
  store r23,(r14+CVoiceSplCpti)
  
; Process voice 2
.readvoice2:
  movei #Voice2,r14
  or  r14,r14
  load  (r14+CVoiceSplEndi),r21    
  load  (r14+CVoiceSplCpti),r23
  
  cmp r21,r23
  jr  mi,.readsample2
  nop
  movei #.endtimerint,r20
  load  (r14+CVoiceSplLoopi),r23
  cmpq  #0,r23
  jump  eq,(r20)
  nop  
.readsample2:
  move  r23,r21
  shrq  #8,r21
  loadb (r21),r26
  or  r26,r26
  move  r26,r27  
  load  (r14+CVoiceVolLefti),r28  
  mult r28,r26  ; vol left
  load  (r14+CVoiceVolRighti),r28
  mult r28,r27  ; vol right
  load  (r14+CVoiceStepi),r22
  add r22,r23 ; step
  add r26,r24 ; mix left
  add r27,r25 ; mix right
  or  r23,r20 ; scoreboard bug
  store r23,(r14+CVoiceSplCpti)
    
.endtimerint:  
  load  (r31),r28  
  bclr  #3,r29
  bset  #10,r29
  addq  #4,r31  
  addq  #2,r28  
  jump  (r28)
  store r29,(r30)
    
initdsp:
  movei #JOYSTICK,r0
  loadw (r0),r1
  bset  #8,r1
 ; movei #$100,r1  
  storew  r1,(r0)
  
  movei #SMODE,r0
  movei #%001101,r1  
  store r1,(r0)
  movei #L_I2S,r15
  moveta  r15,r15
  moveq #0,r24
  moveta  r24,r24
  moveq #0,r25
  moveta  r25,r25
  
  movei #endstack,r31
  moveta  r31,r31
  movei #SCLK,r0
  movei #24,r1
  store r1,(r0)
  movei #D_FLAGS,r0
  movei #D_I2SENA|REGPAGE,r1    
  store r1,(r0) 
  nop
  nop
  nop
  nop
  moveq #7,r19  ; register to check in test reg
    
_realstartdspcode3d::
dspsemcheck:
  movei #DSPSEM,r20
  movei #Collision,r21  
  movei #StopDSP,r22
  movei #Transform,r23
  movei #SetVoiceDSP,r24
    
testdspsem:
    load  (r20),r0
    or  r0,r0
    cmpq  #1,r0       ; Collision
    jump  eq,(r21)
    nop
   
    cmpq  #2,r0       ; Stop DSP
    jump  eq,(r22)
    nop
  
    cmpq  #3,r0       ; Transform
    jump  eq,(r23)
    nop
    
    cmpq  #4,r0       ; SetVoice
    jump  eq,(r24)
    nop
      
    jr    testdspsem
    nop 


; ------------------------------------------------
; Collision
rDx .equr r8
rDz .equr r9
rYmin1  .equr r10
rYmax1  .equr r11
rYmin2  .equr r12
rYmax2  .equr r13
rTester .equr r14
rTested .equr r15
rNextTest .equr r16
rException  .equr r17

cReturn .equr r0

Collision:
  movei #dspparam1,r0
  load  (r0),rTester
  or rTester,rTester
  movei #dspparam2,r0
  load  (r0),rTested
  or rTested,rTested
  movei #dspparam3,r0
  load  (r0),r7
  or r7,r7
  movei #dspparam4,r0
  load  (r0),rException
  or rException,rException
  movei #.nextTest,rNextTest
  moveq #0,r0
  moveta r0,cReturn
  
  subq  #1,r7
.loopTest:
    ; on ne test pas soi-mme     
    cmp rTester,rTested
    jump  eq,(rNextTest)
    nop
    ; Mme type d'objet
    load (rTester+CObjTransObjtypei),r1
    or r1,r1
    load (rTested+CObjTransObjtypei),r2
    or r2,r2
    cmp r1,r2
    jump  eq,(rNextTest)
    nop
    ; Exception
    cmp rException,r2
    jump  eq,(rNextTest)
    nop
    ; If tested->objtype > EExplode
    cmpq  #EExplode,r2
    jump  mi,(rNextTest)
    nop
    jump  eq,(rNextTest)
    nop
    
    load (rTester+CObjTransXi),r0
    or r0,r0
    load (rTested+CObjTransXi),rDx
    or rDx,rDx
    sub r0,rDx
    load (rTester+CObjTransZi),r0
    or r0,r0
    load (rTested+CObjTransZi),rDz
    or rDz,rDz
    sub r0,rDz
    abs rDx
    abs rDz
    
    ; Si trop loin, on ne test pas    
    movei #20000,r0
    cmp r0,rDx
    jump  pl,(rNextTest)
    nop
    cmp r0,rDz
    jump  pl,(rNextTest)
    nop
    
    ; distance -> rDz
    sharq #5,rDx
    sharq #5,rDz
    imult rDx,rDx
    imult rDz,rDz
    add rDx,rDz 
    
    ; Si tested->sqrad+tester->sqrad > d, continue
    load (rTester+CObjTransSqradi),r0
    or r0,r0
    load (rTested+CObjTransSqradi),r1
    or r1,r1
    add r0,r1
    cmp r1,rDz
    jump  pl,(rNextTest)
    nop
    
    ; Tests intervals
    load (rTester+CObjTransYi),r0
    or r0,r0
    load (rTester+CObjTransMinYi),rYmin1
    or rYmin1,rYmin1
    load (rTester+CObjTransMaxYi),rYmax1
    or rYmax1,rYmax1
    add r0,rYmin1
    add r0,rYmax1
    
    load (rTested+CObjTransYi),r0
    or r0,r0
    load (rTested+CObjTransMinYi),rYmin2
    or rYmin2,rYmin2
    load (rTested+CObjTransMaxYi),rYmax2
    or rYmax2,rYmax2
    add r0,rYmin2
    add r0,rYmax2
    
    moveq #0,r0
    moveq #0,r1
    moveq #0,r2
    moveq #0,r3
    moveq #0,r20
    moveq #0,r21
    moveq #0,r22
    moveq #0,r23
    
.test1: 
    ; ymin1>=ymin2
    cmp rYmin2,rYmin1
    jr  mi,.test2
    nop
    moveq #1,r0    
.test2:
    ; ymin1 <= ymax2
    cmp rYmax2,rYmin1
    jr  pl,.test3
    nop
    moveq #1,r1
.test3:
    ; ymax1>=ymin2
    cmp rYmin2,rYmax1
    jr  mi,.test4
    nop
    moveq #1,r2
.test4:
    ; ymax1 <= ymax2
    cmp rYmax2,rYmax1
    jr  pl,.test5
    nop
    moveq #1,r3

.test5: 
    ; ymin2>=ymin1
    cmp rYmin1,rYmin2
    jr  mi,.test6
    nop
    moveq #1,r20    
.test6:
    ; ymin2 <= ymax1
    cmp rYmax1,rYmin2
    jr  pl,.test7
    nop
    moveq #1,r21
.test7:
    ; ymax2>=ymin1
    cmp rYmin1,rYmax2
    jr  mi,.test8
    nop
    moveq #1,r22
.test8:
    ; ymax2 <= ymax1
    cmp rYmax1,rYmax2
    jr  pl,.computeCond
    nop
    moveq #1,r23

.computeCond:
    and r0,r1
    and r2,r3
    or  r1,r3
    and r20,r21
    and r22,r23
    or  r21,r23
    or  r3,r23
    cmpq  #0,r23
    jump  eq,(rNextTest)
    nop
    
.testedShield:
    movei #.testerShield,r2
    load (rTested+CObjTransShieldi),r0
    or r0,r0
    load (rTester+CObjTransDammagei),r1
    or r1,r1
    sub r1,r0
    jump  pl,(r2)
    nop
    moveq #0,r0
    moveq #EExplode,r1
    or  r1,r5 ; scoreboard bug
    store r1,(rTested+CObjTransObjtypei)
    store r0,(rTested+CObjTransExplodei)
.testerShield:
    or  r0,r5 ; scoreboard bug
    store r0,(rTested+CObjTransShieldi)

    movei #.finTesterShield,r2
    load (rTester+CObjTransShieldi),r0
    or r0,r0
    load (rTested+CObjTransDammagei),r1
    or r1,r1
    sub r1,r0
    jump  pl,(r2)
    nop
    moveq #0,r0
    moveq #EExplode,r1
    or  r1,r5 ; scoreboard bug
    store r1,(rTester+CObjTransObjtypei)
    store r0,(rTester+CObjTransExplodei)
.finTesterShield:
    or  r0,r5 ; scoreboard bug
    store r0,(rTester+CObjTransShieldi)
    moveta  r1,cReturn    
    ; collision, pas besoin de continuer  tester
    movei #.exitloop,r2
    jump  (r2)
    nop
    
.nextTest:
    movei #CObjTransSz,r0
    add r0,rTested
    movei #.loopTest,r0
    subq  #1,r7
    jump  ne,(r0)
    nop
.exitloop:
  movei #DSPRES,r1
  movefa cReturn,r0
  store r0,(r1)
  
  movei #DSPSEM,r20
  moveq #31,r0
  store r0,(r20)  
  movei #dspsemcheck,r20
  jump  (r20)
  nop  
  
  .equrundef rDx
  .equrundef rDz
  .equrundef rYmin1
  .equrundef rYmax1
  .equrundef rYmin2
  .equrundef rYmax2
  .equrundef rTester
  .equrundef rTested
  .equrundef rNextTest

  .equrundef cReturn
  
  
; ------------------------------------------------
; Transform
rX  .equr r8
rY  .equr r9
rZ  .equr r10
rPtDst  .equr r11
rPtGeom .equr r12
rNinside  .equr r13

rNoutside .equr r16
rSize   .equr r17
rX2 .equr r18
rY2 .equr r19
rYmin .equr r20
rNAdd   .equr r21
rPtAdd  .equr r22
rPtr  .equr r23
rZ2 .equr r24
rNclipped .equr r25
rPO .equr r26
rPI .equr r27



cXcam   .equr r0
cYcam   .equr r1
cZcam   .equr r2
cType   .equr r3
cYtab   .equr r4
cSinAcam  .equr r5
cCosAcam  .equr r6
cScrW   .equr r7
cScrH   .equr r8
cAngle  .equr r9
cSinA   .equr r10
cCosA   .equr r11
cBaseGeom .equr r12
cPtr    .equr r13   
cXobj   .equr r16
cYobj   .equr r17
cZobj   .equr r18
cExplode  .equr r19

Transform:
  movei #BMP_WIDTH,r0
  moveta  r0,cScrW
  movei #BMP_HEIGHT,r0
  moveta  r0,cScrH

  movei #cntDispEl,r0
  or  r0,r0
  moveq #0,r1
  store r1,(r0)
  
  movei #DSPRES,r0
  or  r0,r0
  store r1,(r0)
  
TransformLoop:
  movei #_displayList,r0
  movei #cntDispEl,r4
  load  (r4),r3
  or  r3,r3
  add r3,r0
  
  load  (r0),r1 ; pt obj
  or  r1,r1
  addq  #4,r0
  load  (r0),r2 ; pt trans
  or  r2,r2  
  
  addq  #8,r3   ; next display list elem
  store r3,(r4)
  
  movei #dspparam2,r0 ; ptrObj
  or  r0,r0
  store r1,(r0)
  movei #dspparam5,r0 ; ptrTrans
  or  r0,r0
  store r2,(r0)
  
  moveq #0,rNclipped
  
  movei #dspparam1,r0
  load  (r0),rPtDst
  or rPtDst,rPtDst
    
  movei #dspparam2,r0 ; ptrObj
  load  (r0),rPtGeom
  or rPtGeom,rPtGeom
  movei #endTransform,r1
  cmpq  #0,rPtGeom
  jump eq,(r1)
  nop
  
  load  (rPtGeom),r7  ; get n tris
  or  r7,r7
  addqt #16,rPtGeom  ; skip to geomtry
  
  movei #dspparam4,r0 ; cam
  load  (r0),r1
  or r1,r1
  load  (r1),rX
  or rX,rX
  addqt #4,r1
  load  (r1),rY
  or rY,rY
  addqt #4,r1
  load  (r1),rZ
  or rZ,rZ
  addqt #4,r1
  load  (r1),r0
  or r0,r0
  move  r0,r3
  moveta  rX,cXcam
  moveta  rY,cYcam
  moveta  rZ,cZcam  

  movei #_sintab,rPtr
  move  r3,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  or r1,r1
  moveta  r1,cSinAcam
  
  move  r3,r0
  movei #512,r1
  movei #2047,r2
  add r1,r0
  and r2,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  or r1,r1
  moveta  r1,cCosAcam

  movei #dspparam5,r0 ; Trans
  load  (r0),r14
  or  r14,r14
  load  (r14+CObjTransXi),r1
  or r1,r1
  moveta  r1,cXobj
  load  (r14+CObjTransYi),r1
  or r1,r1
  moveta  r1,cYobj
  load  (r14+CObjTransZi),r1
  or r1,r1
  moveta  r1,cZobj
  load  (r14+CObjTransAngleYi),r1
  or r1,r1
  move  r1,r3
  
  movei #_sintab,rPtr
  move  r3,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  or  r1,r1
  moveta  r1,cSinA
  
  move  r3,r0
  movei #512,r1
  movei #2047,r2
  add r1,r0
  and r2,r0
  shlq  #1,r0
  add rPtr,r0
  loadw (r0),r1
  or r1,r1
  moveta  r1,cCosA
  
  ; Test boundaries
  movefa cXobj,rX
  movefa cZobj,rZ
  movefa cXcam,r0
  movefa cZcam,r1
  sub r0,rX
  sub r1,rZ
  move rX,r0
  move rZ,r1
  abs r0
  abs r1  
  movei #100<<10,r2
  movei #endTransform,r3
  cmp r2,r0     ; X delta too big?
  jump pl,(r3)
  nop
  cmp r2,r1   ; Z delta too big?
  jump pl,(r3)
  nop
  
  ; Check if behind
  sharq #8,rX   ; cam to obj vector
  sharq #8,rZ
  movefa cSinAcam,rX2  ; cam direction vector
  movefa cCosAcam,rZ2
  imult rX,rX2
  imult rZ,rZ2
  add rX2,rZ2
  cmpq  #0,rZ2
  jump mi,(r3)
  nop
  
  load  (r14+CObjTransExplodei),r1
  or r1,r1
  moveta r1,cExplode
  
; Vertex transformation
  movei #endTransform,r0
  cmpq  #0,r7
  jump  eq,(r0)
  nop
  
  subq  #1,r7
.loopTriTrans:
    movei #CVertexSz,rSize
    moveq #2,r6
    movei #.loopTrans,r29
    
    move rPtGeom,r14
    movei #CTriangleNx,r0 ; normal
    add r0,r14
    load  (r14),rX
    or rX,rX
    load  (r14+1),rY
    or rY,rY
    load  (r14+2),rZ
    or rZ,rZ
    movefa  cExplode,r0
    imult r0,rX
    imult r0,rY
    imult r0,rZ
    sharq #2,rX
    sharq #2,rY
    sharq #2,rZ
    movei #NX,r15    
    or  r15,r15
    store  rX,(r15)
    or rY,r5  ; scoreboard bug
    store  rY,(r15+1)
    or rZ,r5  ; scoreboard bug
    store  rZ,(r15+2)
    
    move  rPtGeom,r14
    moveq #0,r3
.loopTrans:
      load  (r14+CVertexXwi),rX
      or rX,rX
      load  (r14+CVertexYwi),rY
      or rY,rY
      load  (r14+CVertexZwi),rZ
      or rZ,rZ
      
      ; explode trans
      load  (r15),rX2
      or rX2,rX2     
      load  (r15+1),rY2
      or rY2,rY2      
      load  (r15+2),rZ2  
      or rZ2,rZ2    
      add rX2,rX
      add rY2,rY
      add rZ2,rZ
      
      ; local rotY
      move  rX,rX2
      move  rY,rY2
      move  rZ,rZ2
      
      movefa  cCosA,r0
      movefa  cSinA,r1
      imult r0,rX
      imult r1,rZ
      sharq #10,rX
      sharq #10,rZ
      sub rZ,rX
      
      imult r1,rX2
      imult r0,rZ2
      sharq #10,rX2
      sharq #10,rZ2
      add rX2,rZ2
      move  rZ2,rZ      
      
      ; world trans
      movefa cXobj,r0
      movefa cYobj,r1
      movefa cZobj,r2
      add r0,rX
      add r1,rY
      add r2,rZ
      
      ; cam trans
      movefa cXcam,r0
      movefa cYcam,r1
      movefa cZcam,r2
      sub r0,rX
      sub r1,rY
      sub r2,rZ
      
      ; cam rotY
      move  rX,rX2
      move  rY,rY2
      move  rZ,rZ2

      movefa  cCosAcam,r0
      movefa  cSinAcam,r1
      sharq #3,rX   ; reduce precision to improve range
      sharq #3,rZ
      imult r0,rX
      imult r1,rZ
      sharq #7,rX
      sharq #7,rZ
      sub rZ,rX
      
      sharq #3,rX2   ; reduce precision to improve range
      sharq #3,rZ2
      imult r1,rX2
      imult r0,rZ2
      sharq #7,rX2
      sharq #7,rZ2
      add rX2,rZ2
      move  rZ2,rZ  
      
      or  rX,r5 ; scoreboard bug
      store rX,(r14+CVertexXti)
      or  rY,r5 ; scoreboard bug
      store rY,(r14+CVertexYti)
      or  rZ,r5 ; scoreboard bug
      store rZ,(r14+CVertexZti)
      
      sharq #2,rZ
      add rZ,r3   ; compute face Z
      
      add rSize,r14
      subq  #1,r6
      jump  pl,(r29)
      nop
    movei #CTriangleZ,r0
    move  rPtGeom,r14
    or  r3,r5 ; scoreboard bug  
    store r3,(r14+r0)   ; save face Z
    
    movei #CTriangleNx,r0 ; Rotate normal
    add r0,r14
    load  (r14),rX
    or rX,rX
    load  (r14+1),rY
    or rY,rY
    load  (r14+2),rZ
    or rZ,rZ
    
    ; local rot Y
    move  rX,rX2
    move  rY,rY2
    move  rZ,rZ2
    
    movefa  cCosA,r0
    movefa  cSinA,r1
    imult r0,rX
    imult r1,rZ
    sharq #10,rX
    sharq #10,rZ
    sub rZ,rX
    
    imult r1,rX2
    imult r0,rZ2
    sharq #10,rX2
    sharq #10,rZ2
    add rX2,rZ2
    move  rZ2,rZ
    
    ; cam rotY
    move  rX,rX2
    move  rY,rY2
    move  rZ,rZ2

    movefa  cCosAcam,r0
    movefa  cSinAcam,r1    
    imult r0,rX
    imult r1,rZ
    sharq #10,rX
    sharq #10,rZ
    sub rZ,rX
        
    imult r1,rX2
    imult r0,rZ2
    sharq #10,rX2
    sharq #10,rZ2
    add rX2,rZ2
    move  rZ2,rZ  
    
    movei #CTriangleNxt,r0
    move  rPtGeom,r14   
    add r0,r14    
    or  rX,r5 ; scoreboard bug
    store rX,(r14)
    or  rY,r5 ; scoreboard bug
    store rY,(r14+1)
    or  rZ,r5 ; scoreboard bug
    store rZ,(r14+2)
    
    movei #.loopTriTrans,r29
    movei #CTriangleSz,rSize
    add rSize,rPtGeom
    subq  #1,r7
    jump  pl,(r29)
    nop
 
; Triangle clipping
  movei #_nTriAdd,r0
  load  (r0),rNAdd
  or rNAdd,rNAdd
  movei #_ptTriAdd,r0
  or r0,r0
  load  (r0),rPtAdd
  or rPtAdd,rPtAdd
  movei #CTriangleSz,r0
  imult rNAdd,r0
  add r0,rPtAdd
  
  moveq #0,rNclipped
  movei #dspparam6,r0
  load  (r0),rPtr
  or rPtr,rPtr
  
  movei #dspparam2,r0
  load  (r0),rPtGeom
  or rPtGeom,rPtGeom
  load  (rPtGeom),r7  ; get n tris
  or r7,r7
  addqt #16,rPtGeom  ; skip to geometry
  moveta  rPtGeom,cBaseGeom
  subq  #1,r7
.loopTriClip:
    ; backface culling
    movei #.nextTriClip,r29
    movei #CTriangleNxt,r0
    move  rPtGeom,r14
    load  (r14+CVertexXti),rX
    or rX,rX
    load  (r14+CVertexYti),rY
    or rY,rY
    load  (r14+CVertexZti),rZ
    or rZ,rZ
    add r0,r14
    load  (r14),rX2
    or rX2,rX2
    load  (r14+1),rY2
    or rY2,rY2
    load  (r14+2),rZ2
    or rZ2,rZ2
    sharq #4,rX
    sharq #4,rY
    sharq #4,rZ
    imultn rX,rX2
    imacn rY,rY2
    imacn rZ,rZ2
    resmac r1
    cmpq  #0,r1
   ; imult rX,rX2
   ; imult rY,rY2
   ; imult rZ,rZ2
   ; add rZ2,rY2
   ; add rY2,rX2
   ; cmpq  #0,rX2
    jump  pl,(r29)
    nop
    
    ; clipping
    moveq #0,rNinside
    moveq #0,rNoutside
    moveq #2,r6
    movei #.loopSortInsideOutside,r29
    movei #CLIP_DIST,r0
    move  rPtGeom,r14
    movei #CVertexSz,rSize
    movei #po,rPO
    movei #pi,rPI
    
.loopSortInsideOutside:
      load  (r14+CVertexZti),r1
      or r1,r1
      cmp   r0,r1
      jr  pl,.pointInside
      nop      
      store r14,(rPO)
      addq #4,rPO
      addq #1,rNoutside
      jr .nextSortPoint
      nop 
.pointInside:
      store r14,(rPI)
      addq #4,rPI
      addq #1,rNinside
.nextSortPoint:      
      add rSize,r14
      subq  #1,r6
      jump  pl,(r29)
      nop
    
    movei #.nextTriClip,r29
    cmpq  #3,rNoutside
    jr  ne,.testNoutside0
    nop
    ; all outside, no tri to add
    jump  (r29)
    nop
    
.testNoutside0:
    movei #.testNoutside1,r0
    cmpq  #0,rNoutside
    jump  ne,(r0)
    nop
    ; all inside, add tri as is  
    move  rPtGeom,r15
    move  rPtAdd,r14
    movei #CVertexSz,rSize
    moveq #2,r6
.loopCoyTri0:
      load  (r15+CVertexXti),rX
      or rX,rX
      load  (r15+CVertexYti),rY
      or rY,rY
      load  (r15+CVertexZti),rZ
      or  rZ,rZ
      or  rX,r20 ; scoreboard bug
      store rX,(r14+CVertexXti)
      or  rY,r20 ; scoreboard bug
      store rY,(r14+CVertexYti)
      or  rZ,r20 ; scoreboard bug
      store rZ,(r14+CVertexZti)
      add rSize,r14
      add rSize,r15
      subq  #1,r6
      jr  pl,.loopCoyTri0
      nop
    movei #CTriangleCol,r0  ; offset triangle col
    move  r0,r1
    addqt #4,r1             ; offset triangle z
    move  rPtGeom,r15
    move  rPtAdd,r14
    load  (r15+r0),r2
    or  r2,r2
    load  (r15+r1),r3
    or  r3,r3
    or  r2,r20 ; scoreboard bug
    store r2,(r14+r0)
    or  r3,r20 ; scoreboard bug
    store r3,(r14+r1)
    nop
    store rPtAdd,(rPtr)
    addq #4,rPtr
    
    movei #CTriangleSz,r0
    add r0,rPtAdd
    addq #1,rNAdd
    addq #1,rNclipped
    jump  (r29)
    nop

;if (n_outside == 1)
.testNoutside1:
    movei #.testNoutside2,r0
    cmpq  #1,rNoutside
    jump  ne,(r0)
    nop
       
.clip1n1:
    movei #pi,rPI
    movei #po,rPO
    movei #QX1,rPtDst
    movei #.clip1n2,r28
    movei #clipLine,r0
    jump  (r0)
    nop
.clip1n2:
    movei #pi,rPI
    addq  #4,rPI
    movei #po,rPO
    movei #QX2,rPtDst
    movei #.copyTri1,r28
    movei #clipLine,r0
    jump  (r0)
    nop    
.copyTri1:
    movei #CTriangleCol,r1
    add rPtGeom,r1
    load  (r1),r4 ; face color
    or r4,r4
    addq #4,r1
    or r1,r1
    load  (r1),r5 ; face Z
    or r5,r5
    
    movei #CVertexSz,rSize
    move  rPtAdd,r14
    movei #pi,rPI
    load  (rPI),r15
    or r15,r15
    
    ;trisclipped[ntriclipped].p[0] = pi[0];
    load  (r15+CVertexXti),rX
    or  rX,rX
    load  (r15+CVertexYti),rY
    or  rY,rY
    load  (r15+CVertexZti),rZ
    or rZ,rZ
    or  rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or  rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or  rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)

    movei #QX1,r1
    movei #QX2,r2
    movei #po,rPO
    or  rPO,rPO
    load  (rPO),r15
    or  r15,r15    
    load  (r15+CVertexIndexi),r0
    or r0,r0
    cmpq  #1,r0 ; if (po[0].index == 1)
    jr  eq,.noFlipCopyTri1A
    nop
    movei #QX2,r1
    movei #QX1,r2
.noFlipCopyTri1A:
    ;trisclipped[ntriclipped].p[1] = clip1 / clip2
    move  r1,r15
    add   rSize,r14
        
    load  (r15),rX
    or  rX,rX
    load  (r15+1),rY
    or  rY,rY
    load  (r15+2),rZ    
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
           
    ;trisclipped[ntriclipped].p[2] = clip2 / clip1
    move  r2,r15
    add rSize,r14
        
    load  (r15),rX
    or  rX,rX
    load  (r15+1),rY
    or  rY,rY
    load  (r15+2),rZ    
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
    
    movei #CTriangleCol,r1    
    add rPtAdd,r1
    or  r1,r1
    store r4,(r1) ; save col
    addq  #4,r1
    or  r1,r1
    store r5,(r1) ; save Z
    or  rPtAdd,rPtAdd
    store rPtAdd,(rPtr)
    addq #4,rPtr
    addq #1,rNclipped
    addq #1,rNAdd
        
    movei #CTriangleSz,rSize
    add rSize,rPtAdd
    move  rPtAdd,r14    
    movei #CVertexSz,rSize
    
    movei #pi,rPI
    move  rPI,r1  ; pi[0]
    addq #4,rPI    
    move  rPI,r2  ; pi[1]
    
    cmpq  #1,r0 ; if (po[0].index == 1)
    jr  eq,.noFlipCopyTri1B
    nop    
    move  r2,r3   ; swap pointers
    move  r1,r2
    move  r3,r1
.noFlipCopyTri1B:
    load  (r2),r15
    or r15,r15        
    ; trisclipped[ntriclipped].p[0] = pi[1];
    load  (r15+CVertexXti),rX
    or  rX,rX
    load  (r15+CVertexYti),rY
    or  rY,rY
    load  (r15+CVertexZti),rZ
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
    
    load  (r1),r15
    or r15,r15
    add rSize,r14
    ;trisclipped[ntriclipped].p[1] = pi[0];
    load  (r15+CVertexXti),rX
    or  rX,rX
    load  (r15+CVertexYti),rY
    or  rY,rY
    load  (r15+CVertexZti),rZ
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
    
    movei #QX2,r15
    add rSize,r14
    ;trisclipped[ntriclipped].p[2] = clip2;
    load  (r15),rX
    or  rX,rX     ; if I don't do this here, it craps out when interrupts are enabled.
    load  (r15+1),rY
    or  rY,rY     ; if I don't do this here, it craps out when interrupts are enabled
    load  (r15+2),rZ
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
    
    movei #CTriangleCol,r1    
    add rPtAdd,r1
    or  r1,r1
    store r4,(r1)   ; save col    
    addq #4,r1
    or  r1,r1
    store r5,(r1)   ; save Z
    or rPtAdd,rPtAdd
    store rPtAdd,(rPtr)
    addq #4,rPtr
    addq #1,rNclipped
    addq #1,rNAdd
    
    movei #CTriangleSz,rSize
    add rSize,rPtAdd   
    
    jump  (r29)
    nop

; if (n_outside == 2)
.testNoutside2:
    cmpq  #2,rNoutside
    jump  ne,(r29)
    nop
         
.clip2n1:
    movei #pi,rPI
    movei #po,rPO
    movei #QX1,rPtDst
    movei #.clip2n2,r28
    movei #clipLine,r0
    jump  (r0)
    nop
.clip2n2:
    movei #pi,rPI
    movei #po,rPO
    addq  #4,rPO
    movei #QX2,rPtDst
    movei #.copyTri2,r28
    movei #clipLine,r0
    jump  (r0)
    nop
.copyTri2:
    movei #CTriangleCol,r1
    add rPtGeom,r1
    load  (r1),r4 ; face col
    or r4,r4
    addq   #4,r1
    load  (r1),r5 ; face Z
    or r5,r5
    
    movei #CVertexSz,rSize
    move  rPtAdd,r14
    load  (rPI),r15
    
    ; trisclipped[ntriclipped].p[0] = pi[0]
    load  (r15+CVertexXti),rX
    or  rX,rX
    load  (r15+CVertexYti),rY
    or  rY,rY
    load  (r15+CVertexZti),rZ
    or  rZ,rZ
    load  (r15+CVertexIndexi),r0
    or r0,r0
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
        
    movei #QX2,r2
    movei #QX1,r1    
    cmpq  #1,r0 ;if (pi[0].index == 1)
    jr  eq,.noFlipCopyTri2
    nop
    movei #QX2,r1
    movei #QX1,r2
.noFlipCopyTri2:
    ; trisclipped[ntriclipped].p[1] = clip2  / clip1
    move  r2,r15
    add rSize,r14
    load  (r15),rX
    or  rX,rX
    load  (r15+1),rY
    or  rY,rY
    load  (r15+2),rZ
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)
    
    ; trisclipped[ntriclipped].p[2] = clip1 / clip2
    move  r1,r15
    add rSize,r14
    load  (r15),rX
    or  rX,rX     ; if I don't do this here, it craps out when interrupts are enabled.
    load  (r15+1),rY
    or  rY,rY     ; if I don't do this here, it craps out when interrupts are enabled.
    load  (r15+2),rZ
    or rZ,rZ
    or rX,r20 ; scoreboard bug
    store rX,(r14+CVertexXti)
    or rY,r20 ; scoreboard bug
    store rY,(r14+CVertexYti)
    or rZ,r20 ; scoreboard bug
    store rZ,(r14+CVertexZti)

    movei #CTriangleCol,r1
    add rPtAdd,r1
    or  r1,r1
    store r4,(r1) ; save col
    addq #4,r1
    or  r1,r1
    store r5,(r1) ; save z
    
    or rPtAdd,rPtAdd
    store rPtAdd,(rPtr)
    addq #4,rPtr
    addq #1,rNclipped
    addq #1,rNAdd
    
    movei #CTriangleSz,rSize
    add rSize,rPtAdd
      
.nextTriClip:
    movei #.loopTriClip,r29
    movei #CTriangleSz,rSize
    add rSize,rPtGeom
    subq  #1,r7
    jump  pl,(r29)
    nop
  
        
  movei #_nTriAdd,r0
  or  r0,r0
  store rNAdd,(r0)
  
; Vertex projection
  movei #dspparam6,r0
  load  (r0),rPtr
  or  rPtr,rPtr
  
  movei #endTransform,r29
  move  rNclipped,r7
  cmpq  #0,r7
  jump  eq,(r29)
  nop
  subq  #1,r7
.loopTriProj:
    movei #CVertexSz,rSize
    moveq #2,r6
    movei #.loopProj,r29
    load  (rPtr),rPtGeom
    or rPtGeom,rPtGeom
    move  rPtGeom,r14
.loopProj:    
      load  (r14+CVertexXti),rX
      or rX,rX
      load  (r14+CVertexYti),rY
      or  rY,rY
      load  (r14+CVertexZti),rZ
      or  rZ,rZ
      sharq #7,rZ
      
      move  rX,r0
      move  rY,r1
      abs r0
      abs r1
      div rZ,r0
      cmpq  #0,rX
      jr  pl,.Xpos
      nop
      neg r0
.Xpos:
      or  r0,r0
      
      div rZ,r1
      cmpq  #0,rY
      jr  pl,.Ypos
      nop
      neg r1
.Ypos:
      or  r1,r1
      
      movefa  cScrW,r2
      shrq  #1,r2
      add r2,r0
      movefa  cScrH,r2
      shrq  #1,r2
      sub r1,r2
      or  r0,r20 ; scoreboard bug
      store r0,(r14+CVertexXproji)
      or  r2,r20 ; scoreboard bug
      store r2,(r14+CVertexYproji)
             
      subq  #1,r6
      jump  pl,(r29)
      add rSize,r14
    
    movei #.loopTriProj,r29
    addqt #4,rPtr
    subq  #1,r7
    jump  pl,(r29)
    nop
   
endTransform:
  ; add nombre total de triangle  rasteriser       
  movei #DSPRES,r20
  or  r20,r20
  load  (r20),r0
  or  r0,r0
  add  rNclipped,r0
  store r0,(r20)
  
  ; add offset tableau de triangle
  shlq  #2,rNclipped
  movei #dspparam6,r0
  or  r0,r0
  load  (r0),r1
  or  r1,r1
  add rNclipped,r1  
  store r1,(r0)
  
  ; Dcompte le nombre de display element
  movei #_nDisplay,r0
  or  r0,r0
  load  (r0),r1
  or  r1,r1
  subq  #1,r1  
  store r1,(r0)
  movei #TransformLoop,r2
  cmpq  #0,r1
  jump  ne,(r2)
  nop

  movei #DSPSEM,r20
  moveq #31,r0
  store r0,(r20)
   
  movei #dspsemcheck,r20
  or  r20,r20
  jump  (r20)
  nop
  
; -------------------------------------------
; rPI rPO rPtDst  
clipLine:
  load  (rPI),r14
  or  r14,r14
  load  (rPO),r15
  or  r15,r15
  load  (r14+CVertexZti),r0
  or r0,r0
  load  (r15+CVertexZti),r1
  or r1,r1
  ; denom = (p1.zt-p0.zt)>>6
  sub r0,r1     
  sharq #6,r1
  movei #.clipNoDivZero,r2
  cmpq  #0,r1
  jump  ne,(r2)
  nop
  load  (r15+CVertexXti),rX2
  or rX2,rX2
  load  (r15+CVertexYti),rY2
  or rY2,rY2
  movei #CLIP_DIST,rZ2  
  store rX2,(rPtDst)
  addq #4,rPtDst
  or  rPtDst,rPtDst
  store rY2,(rPtDst)
  addq #4,rPtDst
  or  rPtDst,rPtDst
  store rZ2,(rPtDst)
  jump  (r28)
  nop  
.clipNoDivZero:
  ; num = (CLIP_DIST- p0.zt)<<4
  movei #CLIP_DIST,r2
  sub r0,r2
  shlq  #4,r2
  abs r1
  abs r2
  div r1,r2  
  load  (r14+CVertexXti),rX
  or rX,rX
  load  (r14+CVertexYti),rY
  or rY,rY
  load  (r15+CVertexXti),rX2
  or rX2,rX2
  load  (r15+CVertexYti),rY2
  or rY2,rY2
  sub rX,rX2
  sub rY,rY2
  imult r2,rX2
  imult r2,rY2  
  sharq #10,rX2
  sharq #10,rY2
  add rX,rX2
  add rY,rY2
  movei #CLIP_DIST,rZ2
  store rX2,(rPtDst)
  addq #4,rPtDst
  or  rPtDst,rPtDst
  store rY2,(rPtDst)
  addq #4,rPtDst
  or  rPtDst,rPtDst
  store rZ2,(rPtDst)
  jump  (r28)
  nop


  .equrundef rX
  .equrundef rY 
  .equrundef rZ  
  .equrundef rPtDst
  .equrundef rPtGeom
  .equrundef rNinside

  .equrundef rNoutside 
  .equrundef rSize
  .equrundef rX2
  .equrundef rY2
  .equrundef rYmin
  .equrundef rNAdd
  .equrundef rPtAdd
  .equrundef rPtr
  .equrundef rZ2
  .equrundef rNclipped
  .equrundef rPO
  .equrundef rPI  
  
  .equrundef cYcam
  .equrundef cXcam
  .equrundef cZcam
  .equrundef cType
  .equrundef cYtab
  .equrundef cSinAcam
  .equrundef cCosAcam
  .equrundef cScrW
  .equrundef cScrH
  .equrundef cAngle
  .equrundef cSinA
  .equrundef cCosA  
  .equrundef cBaseGeom
  .equrundef cPtr
  .equrundef cXobj
  .equrundef cYobj
  .equrundef cZobj
  .equrundef cExplode
  
  
; -------------------------------------------
; SetVoice DSP

rPtrLoop  .equr r8
rPtrStart .equr r9
rPtrEnd   .equr r10
rPtrVoice .equr r14
  
SetVoiceDSP:
  movei #dspparam1,r0
  load  (r0),rPtrLoop
  or rPtrLoop,rPtrLoop
  
  movei #dspparam2,r0
  load  (r0),rPtrStart
  or  rPtrStart,rPtrStart
  
  movei #dspparam3,r0
  load  (r0),rPtrEnd
  or  rPtrEnd,rPtrEnd
  
  movei #dspparam4,r0
  load  (r0),r14
  or  r14,r14
  
  or  rPtrLoop,r5 ; scoreboard bug
  store rPtrLoop,(r14+CVoiceSplLoopi)
  
  or  rPtrEnd,r5 ; scoreboard bug
  store rPtrEnd,(r14+CVoiceSplEndi)
  
  or  rPtrStart,r5 ; scoreboard bug
  store rPtrStart,(r14+CVoiceSplCpti)
  
  movei #DSPRES,r20
  moveq #0,r0
  store r0,(r20)

  movei #DSPSEM,r20
  moveq #31,r0
  store r0,(r20)  
  movei #dspsemcheck,r20
  jump  (r20)
  nop
  
  .equrundef rPtr


; ------------------------------------------------
; StopDSP
; No parameters        
StopDSP:	
  ;movei #BG,r0
  ;movei #$8888,r1
  ;storew  r1,(r0)  	
	movei #D_CTRL,r1
	movei #0,r0		; Stop DSP
	store r0,(r1)	 
	nop             		; Two "feet" on the brake pedal
	nop

  .long
QCol: dc.l  0
QX0:  dc.l  0
QY0:  dc.l  0
QZ0:  dc.l  0
QX1:  dc.l  0
QY1:  dc.l  0
QZ1:  dc.l  0
QX2:  dc.l  0
QY2:  dc.l  0
QZ2:  dc.l  0
NX:   dc.l  0
NY:   dc.l  0
NZ:   dc.l  0

pi: dc.l  0
    dc.l  0
    dc.l  0
po: dc.l  0
    dc.l  0
    dc.l  0
      
Voice0: dc.l  0
        dc.l  0
        dc.l  0
        dc.l  31
        dc.l  31
        dc.l  256        
Voice1: dc.l  0
        dc.l  0
        dc.l  0        
        dc.l  31
        dc.l  31
        dc.l  256
Voice2: dc.l  0
        dc.l  0
        dc.l  0        
        dc.l  31
        dc.l  31
        dc.l  256
                
_timer8KHz: dc.l  0

cntDispEl:  dc.l  0

beginstack: dc.l 0
            dc.l 0
            dc.l 0
endstack:   dc.l 0

_enddspcode3d::
	  nop
		nop
