
  .include "JAGUAR.INC"
  .include "graphics.inc"
  .include "game68k.inc"
  
  .globl _vidmem
 ; .globl Ytab
  .globl GameVideoIT
	
	.globl gpuparam1
	.globl gpuparam2
	.globl gpuparam3
	.globl gpuparam4
	.globl gpuparam5
	.globl gpuparam6

	.globl dspparam1
	.globl dspparam2
	.globl dspparam3
	.globl dspparam4
	.globl dspparam5
  .globl dspparam6
  
  .globl _nTriAdd
  
	.globl _sintab
	.globl _asintab
	.globl _font8x8_8
  .globl _font8x8_8f	
	.globl _palette
	.globl _title
	  
	.globl _PlanctonObj
	.globl _MineObj
	.globl _TorpedoObj
	.globl _TransportObj
	.globl _ShipObj
	.globl _DroneObj
	.globl _RedTorpedoObj
	.globl _PlayerShipObj
	
	.globl _displayList
	.globl _nDisplay
  .globl _trisAdd
  .globl _trisAdd2
  .globl _ptTriAdd
  
  .globl _sonar2sound
  .globl _sonar2soundend
  .globl _crunchsound
  .globl _crunchsoundend
  .globl _explodesound
  .globl _explodesoundend
  .globl _metalsound
  .globl _metalsoundend
  .globl _torpedosound
  .globl _torpedosoundend
  .globl _AStrangerDeathsound
  .globl _AStrangerDeathsoundend
  
  .extern Voice0  
  .extern Voice1
  .extern Voice2
  .extern _timer8KHz
  

; -------------------------------------------------------
; Externals
; -------------------------------------------------------	

	.extern _ActiveBitmapArray

  .text
  .68000

; ------------------------------------------------
; TransformListDSP
; (long) pt video buffer
; (long) pt cam
; (long) ptr tri clipped
_TransformListDSP::
  move.l 4(sp),dspparam1
  move.l 8(sp),dspparam4
  move.l 12(sp),dspparam6
  lea DSPSEM,a0 
  move.l  #3,(a0)
  rts
    
; ------------------------------------------------
; Raster
; (long) ptr video buffer
; (long) ptr tri clipped
; (long) n tri clipped
_Raster::
  move.l 4(sp),gpuparam1
  move.l 8(sp),gpuparam2
  move.l 12(sp),gpuparam3
  lea GPUSEM,a0 
  move.l  #2,(a0)
  rts
  
; ------------------------------------------------
; CollisionDSP
; (long) ptr objtrans tester
; (long) ptr objtrans tested array
; (long) nobj
; (long) exception
_CollisionDSP::
  move.l  4(sp),dspparam1
  move.l  8(sp),dspparam2
  move.l  12(sp),dspparam3
  move.l  16(sp),dspparam4
  lea DSPSEM,a0
  move.l  #1,(a0)
  rts

; ------------------------------------------------
; DrawSonar
; (long) pt video mem
; (long) ptr cam
; (long) ptr objects
; (long) n objects
; (long) sonar step
_DrawSonar::
  move.l 4(sp),gpuparam1
  move.l 8(sp),gpuparam2
  move.l 12(sp),gpuparam3
  move.l 16(sp),gpuparam4
  move.l 20(sp),gpuparam5
  lea GPUSEM,a0 
  move.l  #1,(a0)
  rts
  
; ------------------------------------------------    
; SetModeClock (C interface)
; IN: (int) mode|clock
_SetModeClock::
    move.l  4(sp),d0    
    move.w  d0,modeclock
    rts
     
; ------------------------------------------------
; SetVoice
; (long) voice number
; (long) ptr loop
; (long) ptr start
; (long) ptr end
_SetVoice::
  move.l  4(sp),d0
  lea Voice0,a0 ; voice 0 by default
.checkvoice1:
  cmpi.l  #1,d0
  bne.s .checkvoice2
  lea Voice1,a0
  bra.s .loadvoiceparams
.checkvoice2:
  cmpi.l  #2,d0
  bne.s .loadvoiceparams
  lea Voice2,a0
.loadvoiceparams:
  move.l  8(sp),d0
  lsl.l   #8,d0
  move.l  d0,dspparam1 
  
  move.l  12(sp),d0
  lsl.l   #8,d0
  move.l  d0,dspparam2 
  
  move.l  16(sp),d0
  lsl.l   #8,d0
  move.l  d0,dspparam3 
  
  move.l  a0,dspparam4
  
  lea DSPSEM,a0 
  move.l  #4,(a0)
  
  rts

; ------------------------------------------------
; SetVoiceVol
; (long) voice number
; (long) left vol
; (long) right vol  
_SetVoiceVol::
  move.l  4(sp),d0
  lea Voice0,a0 ; voice 0 by default
.checkvoice1:
  cmpi.l  #1,d0
  bne.s .checkvoice2
  lea Voice1,a0
  bra.s .loadvoicevol
.checkvoice2:
  cmpi.l  #2,d0
  bne.s .loadvoicevol
  lea Voice2,a0
.loadvoicevol:
  move.l  8(sp),CVoiceVolLeft(a0)
  move.l  12(sp),CVoiceVolRight(a0)
  rts

; ------------------------------------------------
; SetVoiceStep
; (long) voice number
; (long) step
_SetVoiceStep::
  move.l  4(sp),d0
  lea Voice0,a0 ; voice 0 by default
.checkvoice1:
  cmpi.l  #1,d0
  bne.s .checkvoice2
  lea Voice1,a0
  bra.s .loadvoicestep
.checkvoice2:
  cmpi.l  #2,d0
  bne.s .loadvoicestep
  lea Voice2,a0
.loadvoicestep:
  move.l  8(sp),CVoiceStep(a0)
  rts
  
; ------------------------------------------------
; WaitFrame
; (long) frame time
_WaitFrame::
  move.l  4(sp),d0
      
  ;movem.l d2/d3,-(sp)
  lea _timer8KHz,a0
.testTimer:
  move.l  (a0),d1
  cmp.l d0,d1
  bgt.s .exit_loop
  stop #$2000
  ;move.l  #$7F00,d2
  ;move.l  #$7F5F,d3
  ;muls.w  d2,d3 ; keep the 68K off the bus
  bra.s .testTimer
.exit_loop:
  ;movem.l (sp)+,d2/d3
  rts
  
; -------------------------------------------------------
; Video Interrupt handler
; -------------------------------------------------------	

; ------------------------------------------------
; Game specific video interrupt routine
 
 
GameVideoIT:  
    movem.l  d0-d3/d7/a0/a1,-(sp)    
    move.w  INT1,d0
    btst.l  #1,d0
    beq.s     NotAGPUInterrupt
          
    move.w  #C_GPUCLR|C_VIDENA|C_GPUENA,INT1  ; clear GPU interrupt
    move.w  #$0,INT2
    movem.l  (sp)+,d0-d3/d7/a0/a1
    rte
    
NotAGPUInterrupt:   
    btst.l  #0,d0
    bne.s   VideoInterrupt
    
    ; We shouldn't get here...
    move.w  #C_GPUCLR|C_JERCLR|C_VIDENA|C_GPUENA|C_JERENA,INT1  ; clear GPU interrupt
    move.w  #$0,INT2    
    movem.l  (sp)+,d0-d3/d7/a0/a1 
    rte
   
VideoInterrupt:    
    move.w  modeclock,d0
    ori.w  #BGEN|CSYNC|VIDEN,d0
    move.w  d0,VMODE
       
    move.l  _ActiveBitmapArray,d0
    tst.l   d0
    beq    .NoBitmapArray
    
    move.l  d0,a1
    move.l  CBitmapArrayCount(a1),d7
    tst.w   d7
    beq    .NoBitmapArray
    subq.w  #1,d7  
    move.l  CBitmapArrayPt(a1),d0
    tst.l   d0
    beq    .NoBitmapArray
    move.l  d0,a1
    move.w  #$7FF,d2
    move.w  fby,d3
.loop:
    move.l  CBitmapPtDL(a1),a0
    move.l  CBitmapObj(a1),d0     ; 63 - 32
    andi.l  #$7FFF,d0           ; Clear DATA
    move.l  CBitmapAddr(a1),d1  ; Update DATA     
    lsl.l   #8,d1
    or.l    d1,d0    
    move.l  d0,(a0)   
    move.l  CBitmapObj+4(a1),d0   ; 31 - 0
    move.l  d0,4(a0)
    lea   CBitmapSz(a1),a1
    dbf    d7,.loop
	
    move.l  _ActiveBitmapArray,a1
		move.l  CBitmapArrayDL(a1),d0
		tst.l   d0
		beq.s   .NoBitmapArray
    move.l  d0,OLP
.NoBitmapArray: 
	  add.l	#1,_ticks		; Increment ticks semaphore   
	  move.w  #$FFFF,topvbl
   
; Clear video interupt
		move.w  #C_VIDCLR|C_VIDENA|C_GPUENA,INT1  
		move.w  #$0,INT2 
		movem.l  (sp)+,d0-d3/d7/a0/a1
		rte

  .data
modeclock: .dc.w  RGB16|PWIDTH4

  .phrase
gpuparam1: dc.l 0
gpuparam2: dc.l 0
gpuparam3: dc.l 0
gpuparam4: dc.l 0
gpuparam5: dc.l 0
gpuparam6: dc.l 0

  .long
dspparam1:  dc.l 0
dspparam2:  dc.l 0
dspparam3:  dc.l 0
dspparam4:  dc.l 0
dspparam5:  dc.l 0
dspparam6:  dc.l 0

  .phrase
_nTriAdd:   dc.l  0
_ptTriAdd:  dc.l  0

  .long
_sintab:  .incbin "data/sintab.dat"
;_sintab:  .incbin "data/sintab8.dat"
_asintab: .incbin "data/asin.dat"

  .phrase
_font8x8_8: .incbin "fonts/font8x8_8.raw8"
_font8x8_8f: .incbin "fonts/font8x8_8g.raw8"
_palette:   .incbin "data/pal8.256c"
  .phrase
_title:     .incbin "data/title2.raw8"

  .phrase
_PlanctonObj: .incbin "data/plancton.bin"
  .phrase
_MineObj:     .incbin "data/Icosphere.bin"
  .phrase
_TorpedoObj:  .incbin "data/Torpedo.bin"
  .phrase
_TransportObj:  .incbin "data/Transport.bin"
  .phrase
_ShipObj:     .incbin "data/Ship.bin"
  .phrase
_DroneObj:    .incbin "data/Drone.bin"
  .phrase
_RedTorpedoObj: .incbin "data/RedTorpedo.bin"
  .phrase
_PlayerShipObj: .incbin "data/PlayerShip.bin"

  .phrase
_sonar2sound: .incbin "sounds/SONAR2.wav"
_sonar2soundend:
  .phrase
_crunchsound: .incbin "sounds/crunch.wav"
_crunchsoundend:
  .phrase
_explodesound:  .incbin "sounds/Mine.wav"
_explodesoundend:
  .phrase
_metalsound:  .incbin "sounds/metal_14.wav"
_metalsoundend:
  .phrase
_torpedosound:  .incbin "sounds/torpedo_fire_rev.wav"
_torpedosoundend:
  .phrase
_AStrangerDeathsound: .incbin "sounds/CadmiumXPaulFlintAStrange.wav"
_AStrangerDeathsoundend:
  
  .bss
  .phrase  
_vidmem:  ds.b  BMP_WIDTH*BMP_HEIGHT*2
;Ytab:   ds.l  BMP_HEIGHT*2
  .phrase
_displayList: ds.l  256
_nDisplay:  ds.l  1
  .phrase
_trisAdd:  ds.b  CTriangleSz*400
  .phrase
_trisAdd2:  ds.b  CTriangleSz*400


