#version 430

layout(location = 0) uniform mat4 P;
layout(location = 1) uniform float now;
uniform float dt;

layout(location = 0) in vec3 aPos;
layout(location = 1) in vec3 aNormal;
// Instanced attributes
layout(location = 2) in vec3 iCenter;
layout(location = 3) in vec2 idR; // angular speeds
layout(location = 4) in vec3 iColor;

out vec3 vPos;
out vec3 vPrevPos;
out vec3 vNormal;
out vec3 vColor;

mat3 makeMat(float x, float y)
{
    return mat3(1, 0, 0, 0, cos(y), sin(y), 0, -sin(y), cos(y))
        * mat3(cos(x), 0, sin(x), 0, 1, 0, -sin(x), 0, cos(x));
}

void main()
{
    vec2 a = now * idR, b = (now - dt) * idR;
    mat3 rot = makeMat(a.x, a.y), prevRot = makeMat(b.x, b.y);
    vPos = rot * aPos + vec3(iCenter.xy, -iCenter.z);
    vPrevPos = prevRot * aPos - iCenter;
    vNormal = rot * aNormal;
    vColor = iColor;
    gl_Position = P * vec4(vPos, 1.);
}
