#version 430

uniform float dt;
layout(location = 2) uniform vec3 uLightColor;
layout(location = 3) uniform float uLightStrength;

in vec3 vPos;
in vec3 vPrevPos;
in vec3 vNormal;
in vec3 vColor;

layout(location = 0) out vec2 fragSpeed;
layout(location = 1) out vec4 fragColor;

void main()
{
    fragSpeed = (vPos - vPrevPos).xy / dt;
    fragColor = vec4(uLightColor * vColor * uLightStrength * max(0, -dot(normalize(vNormal), normalize(vPos))), 1.);
}
