#version 430

layout(location = 0) uniform sampler2D texColor;
layout(location = 1) uniform int uDisplayChannel;

in vec2 vTexCoord;

out vec4 fragColor;

void main()
{
    vec4 color = texture(texColor, vTexCoord);
    switch(uDisplayChannel)
    {
    case 1:
        fragColor = vec4(color.r, 0., 0., 1.);
        break;
    case 2:
        fragColor = vec4(0., color.r, 0., 1.);
        break;
    case 3:
        fragColor = vec4(0., 0., color.r, 1.);
        break;
    default:
        fragColor = color;
    }
}
