void draw_sprite(const byte data[], char x, char y) { // routine by Sorunome
  uint8_t* buf = (((y + 8) & 0xF8) >> 1) * 21 + x + gb.display.getBuffer();
  asm volatile(
    "mov R20,%[y]\n\t"
    "ldi R17,7\n\t"
    "add R20,R17\n\t"
    "brmi End\n\t"
    "cpi %[y],48\n\t"
    "brpl End\n\t"
    "inc R20\n\t"
    "ldi R16,8\n\t"
    "andi R20,7\n\t"
    "cpi R20,0\n\t"
    "breq LoopAligned\n"
    "LoopStart:\n\t"
    "tst %[x]\n\t"
    "brmi LoopSkip\n\t"
    "cpi %[x],84\n\t"
    "brcc LoopSkip\n\t"
    "ld R17,Z\n\t"
    "eor R18,R18\n\t"
    "mov R19,R20\n\t"
    "clc\n\t"
    "LoopShift:\n\t" // carry is still reset from the cpi instruction or from the dec
    "rol R17\n\t"
    "rol R18\n\t"
    "dec R19\n\t"
    "brne LoopShift\n\t"
    "tst %[y]\n\t"
    "brmi LoopSkipPart\n\t"
    "ld R19,X\n\t"
    "eor R19,R17\n\t"
    "st X,R19\n\t"
    "LoopSkipPart:\n\t"
    "cpi %[y],40\n\t"
    "brpl LoopSkip\n\t"
    "ld R19,Y\n\t"
    "eor R19,R18\n\t"
    "st Y,R19\n\t"
    "LoopSkip:\n\t"
    "eor R18,R18\n\t"
    "ldi R19,1\n\t"
    "add R26,R19\n\t" // INC DOESN'T CHANGE CARRY!
    "adc R27,R18\n\t"
    "add R28,R19\n\t"
    "adc R29,R18\n\t"
    "add R30,R19\n\t"
    "adc R31,R18\n\t"
    "inc %[x]\n\t"
    "dec R16\n\t"
    "brne LoopStart\n\t"
    "rjmp End\n"
    "LoopAligned:\n\t"
    "tst %[x]\n\t"
    "brmi LoopAlignSkip\n\t"
    "cpi %[x],84\n\t"
    "brcc LoopAlignSkip\n\t"
    "ld R17,Z\n\t"
    "ld R18,X\n\t"
    "eor R18,R17\n\t"
    "st X,R18\n\t"
    "LoopAlignSkip:\n\t"
    "ldi R18,1\n\t"
    "add R26,R18\n\t"
    "adc R27,R20\n\t"
    "add R30,R18\n\t"
    "adc R31,R20\n\t"
    "inc %[x]\n\t"
    "dec R16\n\t"
    "brne LoopAligned\n"
    "End:\n\t"
    ::"x" (buf - 84), "y" (buf), "z" (data), [y] "r" (y), [x] "r" (x):"r16", "r17", "r18", "r19", "r20");
}

void draw_map(const byte map_[], int camera_x, int camera_y) {
  byte map_width = pgm_read_byte(map_);
  byte map_height = pgm_read_byte(map_ + 1);
  for (byte y = 0; y <= 6; y++) {
    for (byte x = 0; x <= 11; x++) {
      int tile_x = camera_x / TILE_WIDTH + x;
      int tile_y = camera_y / TILE_HEIGHT + y;
      if (tile_x >= 0 && tile_x < map_width && tile_y >= 0 && tile_y < map_height) {
        byte tile_num = pgm_read_byte(map_ + 2 + tile_y * map_width + tile_x);
        tile_num += (tile_num >= TILES_ANIMATED_START && tile_num <= TILES_ANIMATED_END) * millis() / ANIMATION_FREQUENCY % 2;
        draw_sprite(tiles_pointer + tile_num * TILE_HEIGHT, x * TILE_WIDTH - camera_x % TILE_WIDTH, y * TILE_HEIGHT - camera_y % TILE_HEIGHT);
      }
    }
  }
}

void draw_player(int x, int y, byte direction, byte animation) {
  gb.display.setColor(WHITE, BLACK);
  gb.display.drawBitmap(x, y, player_masks_pointer[direction * 3 + animation]);
  draw_sprite(player_charset_pointer + (direction * 24 + animation * 8), x, y);
}


void dialog_draw_frame() {
  gb.display.setColor(BLACK);
  gb.display.fillRect(0, 21, 84, 27);
  gb.display.setColor(WHITE);
  gb.display.fillRect(1, 22, 82, 25);
  gb.display.setColor(BLACK);
  gb.display.cursorX = 2;
  gb.display.cursorY = 23;
}

void draw_HP_box(int x, int y) {
  gb.display.setColor(BLACK);
  gb.display.drawFastHLine(x + 1, y, 50);
  gb.display.drawFastHLine(x, y + 1, 52);
  gb.display.drawFastHLine(x + 1, y + 2, 50);
  gb.display.setColor(WHITE);
  gb.display.drawFastHLine(x + 1, y + 1, 50);
  gb.display.setColor(BLACK);
}
