#define EMPTY_DATA 255
#define SLIMES_STATS_LENGTH 6

#define STATS_HP       0
#define STATS_ATT      1
#define STATS_DEF      2
#define STATS_XP       3
#define STATS_XP_CURVE 4
#define STATS_TYPE     5

const byte PROGMEM slimes_stats[] = {
  45, 49, 49, 64, 3, TYPE_GRASS, // HP, ATT, DEF, base EXP, EXP curve, TYPE
  58, 64, 58, 142, 3, TYPE_FIRE,
  44, 48, 65, 66, 3, TYPE_WATER,
  30, 65, 100, 97, 1, TYPE_WATER,
  30, 56, 35, 57, 1, TYPE_NORMAL,
  60, 40, 80, 98, 1, TYPE_NORMAL,
  40, 45, 35, 54, 2, TYPE_POISON,
  80, 80, 50, 90, 2, TYPE_POISON,
  40, 80, 100, 73, 2, TYPE_ROCK,
  100, 100, 100, 64, 3, TYPE_GOLD
};

const byte player_current_slimes[] = { 0, EMPTY_DATA, EMPTY_DATA, EMPTY_DATA, EMPTY_DATA, EMPTY_DATA };

#define PLAYER_DATA_LENGTH 16

#define P_STATS_ID       0
#define P_STATS_LVL      1
#define P_STATS_HP       2
#define P_STATS_XP       3
#define P_STATS_STATE    7
#define P_STATS_ATT_1    8
#define P_STATS_ATT_1_PP 9
#define P_STATS_ATT_2    10
#define P_STATS_ATT_2_PP 11
#define P_STATS_ATT_3    12
#define P_STATS_ATT_3_PP 13
#define P_STATS_ATT_4    14
#define P_STATS_ATT_4_PP 15

const byte player_slimes_data[] = {
  0, 3, 15, 0, 0, 0, 50, 0, 0, 20, EMPTY_DATA, 0, EMPTY_DATA, 0, EMPTY_DATA, 0, // slime_id, LVL, HP, XP (2 bytes), state, ATT_1_id, ATT_1_pp, ATT_2_id, ATT_2_pp, ATT_3_id, ATT_3_pp, ATT_4_id, ATT_4_pp
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  EMPTY_DATA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

