#include <SPI.h>
#include <Gamebuino.h>

Gamebuino gb;

#define TILE_WIDTH 8
#define TILE_HEIGHT 8
#define TILES_PASSABLE_END 11
#define TILES_ANIMATED_START 9
#define TILES_ANIMATED_END 11
#define TILE_BATTLE 3
#define ANIMATION_FREQUENCY 500 // ms
#define KEY_DELAY 5
#define WALK_SPEED 10
#define EVENT_WARP 1
#define EVENT_LOAD_MAP 2
#define EVENT_DIALOG 3

#define LEVEL_MAX 50

#define EVENTS_LENGTH 4
#define WILD_SLIMES_DATA_LENGTH 4

#define TYPE_GRASS 0
#define TYPE_FIRE 1
#define TYPE_WATER 2
#define TYPE_NORMAL 3
#define TYPE_POISON 4
#define TYPE_ROCK 5
#define TYPE_GOLD 6

#include "strings.h"
#include "events.h"
#include "slimes.h"
#include "maps.h"
#include "sprites.h"
#include "graphics.h"
#include "routines.h"
#include "stats.h"

extern const byte font3x5[];

//          gb.display.cursorX = 0;
//          gb.display.cursorY = 0;
//          gb.display.print(house_events[0]);
//          gb.display.update();
//          delay(5000);

void setup() {
  gb.begin();
  gb.display.setFont(font3x5);
  gb.display.persistence = true;
  byte player_x = 6;//22;
  byte player_y = 12;//26;
  byte player_direction = 1;//3;
  byte player_animation = 0;
  const byte* current_map = map_forest;//map_house;
  const byte* current_events = forest_events;//house_events;
  const byte* current_wild_slimes_area = wild_slimes_forest;
  const byte* temp_pointer;
  byte event = EVENT_LOAD_MAP;
  byte event_id;
  byte map_width;
  byte map_height;
  int camera_x;
  int camera_y;
  byte key_delay = 0;
  while (1) {
    if (gb.update()) {
      if (event) {
        switch (event) {
          case EVENT_WARP :
            gb.display.clear();
            gb.display.update();
            current_map = maps[warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH]];
            player_x = warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH + 1];
            player_y = warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH + 2];
            player_direction = warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH + 3];
            current_wild_slimes_area = wild_slimes_areas[warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH]];
            current_events = events[warps[pgm_read_byte(current_events + event_id + 3) * EVENTS_LENGTH]];
          case EVENT_LOAD_MAP :
            map_width = pgm_read_byte(current_map);
            map_height = pgm_read_byte(current_map + 1);
            camera_x = player_x * TILE_WIDTH - LCDWIDTH / 2 + 4;
            camera_x = camera_x * (camera_x > 0) + (map_width * TILE_WIDTH - LCDWIDTH - camera_x) * (camera_x > map_width * TILE_WIDTH - LCDWIDTH);
            camera_y = player_y * TILE_HEIGHT - LCDHEIGHT / 2 + 4;
            camera_y = camera_y * (camera_y > 0) + (map_height * TILE_HEIGHT - LCDHEIGHT - camera_y) * (camera_y > map_height * TILE_HEIGHT - LCDHEIGHT);
            event = 0;
            break;
          case EVENT_DIALOG :
            dialog_draw_frame();
            gb.display.print((const __FlashStringHelper*)pgm_read_word(&dialogs[event_id]));
            dialog_wait_for_key();
            key_delay = KEY_DELAY;
          default :
            event = 0;
        }
      }
      gb.display.clear();
      draw_map(current_map, camera_x, camera_y);
      draw_player(player_x * TILE_WIDTH - camera_x, player_y * TILE_WIDTH - camera_y, player_direction, player_animation);
      char x_temp = -gb.buttons.repeat(BTN_LEFT, 1) * (player_x > 0) + gb.buttons.repeat(BTN_RIGHT, 1) * (player_x < map_width - 1);
      char y_temp = -gb.buttons.repeat(BTN_UP, 1) * (player_y > 0) + gb.buttons.repeat(BTN_DOWN, 1) * (player_y < map_height - 1);
      if (!x_temp != !y_temp) {
        player_direction = (1 + x_temp) * (x_temp != 0);
        player_direction = (2 + y_temp) * (y_temp != 0 || player_direction == 0);
        if (TILES_PASSABLE_END - pgm_read_byte(current_map + 2 + (player_y + y_temp)*map_width + player_x + x_temp) > 0) {
          for (byte i = 1; i <= 8; i++) {
            player_animation += i % 2;
            player_animation *= player_animation < 3 && i < 8;
            camera_x = (player_x * TILE_WIDTH - LCDWIDTH / 2 + 4 + i * x_temp);
            camera_x = camera_x * (camera_x > 0) + (map_width * TILE_WIDTH - LCDWIDTH - camera_x) * (camera_x > map_width * TILE_WIDTH - LCDWIDTH);
            camera_y = player_y * TILE_HEIGHT - LCDHEIGHT / 2 + 4 + i * y_temp;
            camera_y = camera_y * (camera_y > 0) + (map_height * TILE_HEIGHT - LCDHEIGHT - camera_y) * (camera_y > map_height * TILE_HEIGHT - LCDHEIGHT);
            gb.display.clear();
            draw_map(current_map, camera_x, camera_y);
            draw_player(player_x * TILE_WIDTH - camera_x + i * x_temp, player_y * TILE_WIDTH - camera_y + i * y_temp, player_direction, player_animation);
            gb.display.update();
            delay(WALK_SPEED);
          }
          player_x += x_temp;
          player_y += y_temp;
          if (pgm_read_byte(current_map + 2 + (player_y)*map_width + player_x) == TILE_BATTLE) {
#include "battle.h"
          }
          for (byte i = 1; i <= pgm_read_byte(current_events)*EVENTS_LENGTH; i += EVENTS_LENGTH) {
            if (player_x == pgm_read_byte(current_events + i) && player_y == pgm_read_byte(current_events + i + 1)) {
              event = pgm_read_byte(current_events + i + 2);
              event_id = i;
            }
          }
        }
      } else if (gb.buttons.pressed(BTN_A) * (key_delay == 0)) {
        for (byte i = 1; i <= pgm_read_byte(current_events) * 4; i += 4) {
          if (player_x - (player_direction == 2) + (player_direction == 0) == pgm_read_byte(current_events + i) && player_y - (player_direction == 1) + (player_direction == 3) == pgm_read_byte(current_events + i + 1)) {
            event = pgm_read_byte(current_events + i + 2);
            event_id = pgm_read_byte(current_events + i + 3);
          }
        }
      }
      key_delay -= 1 * (key_delay > 0);
    }
  }
}

void loop() {
}
