%% 3.1.1 Etude d'un seuil sur une image

im1 = ima2mat('./19BASEIMAGES/BASEIMAGES/landsattarasconC4');
colormap(gray(256));
image(im1);

% On sépare les pixels en deux classes, < 30 et >= 30
classes = (im1 >= 30) + 1;

figure();
colormap(gray(2));
image(classes);

% Apprentissage

W1 = run_perceptron(im1, classes, 10)

%% 3.1.2 Effet d'une erreur sur une valeur

indices = find(im1 == 110);
size(indices, 1)
classes(indices) = 1;
W2 = run_perceptron(im1, classes, 10)

%% 3.1.3 Effet d'une erreur "fatale" de saturation

indices = find(im1 > 140);
size(indices, 1)
classes(indices) = 1;
W3 = run_perceptron(im1, classes, 15)

%% 3.1.4 Recherche d'une solution de type perceptron à un problème donné

im2 = ima2mat('./19BASEIMAGES/BASEIMAGES/tarascon2Classes');
colormap(gray(2));
image(im2 + 1);
rownum = size(im2, 1);
colnum = size(im2, 2);

fails = zeros(50,1);
for e = 1 : 50
    [fails(e), ~] = run_perceptron(im1, im2 + 1, e);
end;

figure();
plot(fails);