function [fails, W] = run_perceptron(im1, classes, epoch_limit)

rownum = size(im1, 1);
colnum = size(im1, 2);

W = [1 0]; % initial guess
eta = 1;

epochs = 0;
fail = 1;
while fail > 0 && epochs < epoch_limit
    fail = 0;
    for i = 1 : rownum
        for j = 1 : colnum
            pix = im1(i, j);
            ps = W(1) * pix + W(2) * 1;
            if (ps >= 0) && classes(i, j) == 1
                W = W - eta * [pix 1];
                fail = fail + 1;
            elseif (ps <= 0) && classes(i, j) == 2
                W = W + eta * [pix 1];
                fail = fail + 1;
            end;
        end;
    end;
    epochs = epochs + 1;
end;
fails = fail / (rownum * colnum) * 100;
W = W / norm(W);